% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-structures.R
\name{delta_sync_index_spec}
\alias{delta_sync_index_spec}
\title{Delta Sync Vector Search Index Specification}
\usage{
delta_sync_index_spec(
  source_table,
  embedding_writeback_table = NULL,
  embedding_source_columns = NULL,
  embedding_vector_columns = NULL,
  pipeline_type = c("TRIGGERED", "CONTINUOUS")
)
}
\arguments{
\item{source_table}{The name of the source table.}

\item{embedding_writeback_table}{Name of table to sync index contents and
computed embeddings back to delta table, see details.}

\item{embedding_source_columns}{The columns that contain the embedding
source, must be one or list of \code{\link[=embedding_source_column]{embedding_source_column()}}}

\item{embedding_vector_columns}{The columns that contain the embedding, must
be one or list of \code{\link[=embedding_vector_column]{embedding_vector_column()}}}

\item{pipeline_type}{Pipeline execution mode, see details.}
}
\description{
Delta Sync Vector Search Index Specification
}
\details{
\code{pipeline_type} is either:
\itemize{
\item \code{"TRIGGERED"}:  If the pipeline uses the triggered execution mode, the
system stops processing after successfully refreshing the source table in
the pipeline once, ensuring the table is updated based on the data available
when the update started.
\item \code{"CONTINUOUS"} If the pipeline uses continuous execution, the pipeline
processes new data as it arrives in the source table to keep vector index
fresh.
}

The only supported naming convention for \code{embedding_writeback_table} is
\code{"<index_name>_writeback_table"}.
}
\seealso{
\code{\link[=db_vs_indexes_create]{db_vs_indexes_create()}}

Other Vector Search API: 
\code{\link{db_vs_endpoints_create}()},
\code{\link{db_vs_endpoints_delete}()},
\code{\link{db_vs_endpoints_get}()},
\code{\link{db_vs_endpoints_list}()},
\code{\link{db_vs_indexes_create}()},
\code{\link{db_vs_indexes_delete}()},
\code{\link{db_vs_indexes_delete_data}()},
\code{\link{db_vs_indexes_get}()},
\code{\link{db_vs_indexes_list}()},
\code{\link{db_vs_indexes_query}()},
\code{\link{db_vs_indexes_query_next_page}()},
\code{\link{db_vs_indexes_scan}()},
\code{\link{db_vs_indexes_sync}()},
\code{\link{db_vs_indexes_upsert_data}()},
\code{\link{direct_access_index_spec}()},
\code{\link{embedding_source_column}()},
\code{\link{embedding_vector_column}()}
}
\concept{Vector Search API}
