% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cast_hier2dim.R
\name{cast_hier2dim}
\alias{cast_hier2dim}
\alias{cast_hier2dim.default}
\title{Cast Hierarchical List into Dimensional list}
\usage{
cast_hier2dim(x, ...)

\method{cast_hier2dim}{default}(
  x,
  in2out = TRUE,
  maxdepth = 16L,
  recurse_all = FALSE,
  padding = list(NULL),
  direction.names = 0L,
  ...
)
}
\arguments{
\item{x}{a nested list. \cr
If \code{x} has redundant nesting,
it is advisable (though not necessary) to reduce the redundant nesting using \link{dropnests}.}

\item{...}{further arguments passed to or from methods. \cr \cr}

\item{in2out, recurse_all}{see \link{broadcast_casting}.}

\item{maxdepth}{a single, positive integer,
giving the maximum depth to recurse into the list. \cr
The surface-level elements of a list is depth 1. \cr}

\item{padding}{a list of length \code{1},
giving the padding value to use when padding is required. \cr
Padding is used to ensure every all slices of the same dimension in the output
have equal number of elements
(for example, all rows must have the same number of columns).}

\item{direction.names}{see argument \code{direction} from the \link{hiernames2dimnames} method.}
}
\value{
An array of type \code{list}, with the dimensions given by \link{hier2dim}. \cr
If the output needs padding (indicated by \link{hier2dim}),
the output will have more elements than \code{x},
filled with a padding value (as specified in the \code{padding} argument). \cr
\cr
If \code{direction.names = 0} (default), the result will not have any \code{dimnames}; \cr
the \code{dimnames} can then still be constructed using \link{hiernames2dimnames}. \cr
If \code{direction.names} is \code{1} or \code{-1}, the result \emph{will} have \code{dimnames}. \cr \cr
}
\description{
\code{cast_hier2dim()} casts a hierarchical/nested list into a dimensional list
(i.e. an array of type \code{list}). \cr
\cr
This method comes with 2 helper functions: \cr
\link{hier2dim} and \link{hiernames2dimnames} methods. \cr
See their help page for details. \cr \cr
}
\examples{


# Example 1: Basics ====
x <- list(
  group1 = list(
    class1 = list(
      height = rnorm(10, 170),
      weight = rnorm(10, 80),
      sex = sample(c("M", "F", NA), 10, TRUE)
    ),
    class2 = list(
      height = rnorm(10, 170),
      weight = rnorm(10, 80),
      sex = sample(c("M", "F", NA), 10, TRUE)
    )
  ),
  group2 = list(
    class1 = list(
      height = rnorm(10, 170),
      weight = rnorm(10, 80),
      sex = sample(c("M", "F", NA), 10, TRUE)
    ),
    class2 = list(
      height = rnorm(10, 170),
      weight = rnorm(10, 80),
      sex = sample(c("M", "F", NA), 10, TRUE)
    )
  )
)

# predict what dimensions `x` would have if casted as dimensional:
hier2dim(x)

x2 <- cast_hier2dim(x) # cast as dimensional

# since the original list uses the same names for all elements within the same depth,
# dimnames can be set easily:
dimnames(x2) <- hiernames2dimnames(x)

print(x2)


# Example 2: Cast from outside to inside ====
x <- list(
  group1 = list(
    class1 = list(
      height = rnorm(10, 170),
      weight = rnorm(10, 80),
      sex = sample(c("M", "F", NA), 10, TRUE)
    ),
    class2 = list(
      height = rnorm(10, 170),
      weight = rnorm(10, 80),
      sex = sample(c("M", "F", NA), 10, TRUE)
    )
  ),
  group2 = list(
    class1 = list(
      height = rnorm(10, 170),
      weight = rnorm(10, 80),
      sex = sample(c("M", "F", NA), 10, TRUE)
    ),
    class2 = list(
      height = rnorm(10, 170),
      weight = rnorm(10, 80),
      sex = sample(c("M", "F", NA), 10, TRUE)
    )
  )
)

# by default, `in2out = TRUE`;
# for this example, `in2out = FALSE` is used

# predict what dimensions `x` would have if casted as dimensional:
hier2dim(x, in2out = FALSE)

x2 <- cast_hier2dim(x, in2out = FALSE) # cast as dimensional

# since the original list uses the same names for all elements within the same depth,
# dimnames can be set easily:
# because in2out = FALSE, go from the shallow names to the deeper names:
dimnames(x2) <- hiernames2dimnames(x, in2out = FALSE)

print(x2)



# Example 3: padding ====

# For Example 3, take the same list as before, but remove x$group1$class2:

x <- list(
  group1 = list(
    class1 = list(
      height = rnorm(10, 170),
      weight = rnorm(10, 80),
      sex = sample(c("M", "F", NA), 10, TRUE)
    )
  ),
  group2 = list(
    class1 = list(
      height = rnorm(10, 170),
      weight = rnorm(10, 80),
      sex = sample(c("M", "F", NA), 10, TRUE)
    ),
    class2 = list(
      height = rnorm(10, 170),
      weight = rnorm(10, 80),
      sex = sample(c("M", "F", NA), 10, TRUE)
    )
  )
)


hier2dim(x) # as indicated here, dimension 2 (i.e. columns) will have padding

# casting this to a dimensional list will resulting in padding with `NULL`:
x2 <- cast_hier2dim(x)
print(x2)
# The `NULL` values are added for padding.
# This is because all slices of the same dimension need to have the same number of elements.  
# For example, all rows need to have the same number of columns.

# one can also use custom padding:
x2 <- cast_hier2dim(x, padding = list(~ "this is padding"))
print(x2)

dimnames(x2) <- hiernames2dimnames(x)

print(x2)


# we can also use in2out = FALSE:
x2 <- cast_hier2dim(x, in2out = FALSE, padding = list(~ "this is padding"))
dimnames(x2) <- hiernames2dimnames(x, in2out = FALSE)
print(x2)


}
\seealso{
\link{broadcast_casting}, \link{hier2dim}, \link{hiernames2dimnames} \cr
}
