% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa04_broadcast_linearalgebra.R,
%   R/linear_algebra_stats.R
\name{linear_algebra_stats}
\alias{linear_algebra_stats}
\alias{cinv}
\alias{sd_lc}
\title{Simple Linear Algebra Functions for Statistics}
\usage{
cinv(x)

sd_lc(X, vc, bad_rp = NaN)
}
\arguments{
\item{x}{a real symmetric positive-definite square matrix.}

\item{X}{a numeric (or logical) matrix of multipliers/constants}

\item{vc}{the variance-covariance matrix for the (correlated) random variables.}

\item{bad_rp}{if \code{vc} is not a Positive (semi-) Definite matrix,
give here the value to replace bad standard deviations with. \cr \cr}
}
\value{
For \code{cinv()}: \cr
A matrix. \cr
\cr
For \code{sd_lc()}: \cr
A vector of standard deviations.
\cr
\cr
}
\description{
'broadcast' provides some simple Linear Algebra Functions for Statistics: \cr
\code{cinv()}; \cr
\code{sd_lc()}. \cr
\cr
\cr
}
\details{
\bold{cinv()} \cr
\code{cinv()}
computes the Choleski inverse
of a real symmetric positive-definite square matrix. \cr
\cr
\bold{sd_lc()} \cr
Given the linear combination \code{X \%*\% b}, where:
\itemize{
\item \code{X} is a matrix of multipliers/constants;
\item \code{b} is a vector of (correlated) random variables;
\item \code{vc} is the symmetric variance-covariance matrix for \code{b};
}

\code{sd_lc(X, vc)}
computes the standard deviations for the linear combination \code{X \%*\% b},
without making needless copies. \cr
\code{sd_lc(X, vc)} will use \bold{much} less memory than a base 'R' approach. \cr
\code{sd_lc(X, vc)} will \emph{usually} be faster than a base 'R' approach
(depending on the Linear Algebra Library used for base 'R'). \cr
\cr
\cr
}
\examples{

vc <- datasets::ability.cov$cov
X <- matrix(rnorm(100), 100, ncol(vc))

solve(vc)
cinv(vc) # faster than `solve()`, but only works on positive definite matrices
all(round(solve(vc), 6) == round(cinv(vc), 6)) # they're the same

sd_lc(X, vc)

     
}
\references{
John A. Rice (2007), \emph{Mathematical Statistics and Data Analysis} (6th Edition)
}
\seealso{
\link[base]{chol}, \link[base]{chol2inv}
}
