% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gam-tidiers.R
\name{tidy.Gam}
\alias{tidy.Gam}
\alias{Gam_tidiers}
\title{Tidy a(n) Gam object}
\usage{
\method{tidy}{Gam}(x, ...)
}
\arguments{
\item{x}{A \code{Gam} object returned from a call to \code{\link[gam:gam]{gam::gam()}}.}

\item{...}{Additional arguments. Not used. Needed to match generic
signature only. \strong{Cautionary note:} Misspelled arguments will be
absorbed in \code{...}, where they will be ignored. If the misspelled
argument has a default value, the default value will be used.
For example, if you pass \code{conf.lvel = 0.9}, all computation will
proceed using \code{conf.level = 0.95}. Additionally, if you pass
\code{newdata = my_tibble} to an \code{\link[=augment]{augment()}} method that does not
accept a \code{newdata} argument, it will use the default value for
the \code{data} argument.}
}
\value{
The tidied output of the parametric ANOVA for the GAM model as
a \link[tibble:tibble]{tibble::tibble} with one row for each term in the model.
}
\description{
Tidy summarizes information about the components of a model.
A model component might be a single term in a regression, a single
hypothesis, a cluster, or a class. Exactly what tidy considers to be a
model component varies cross models but is usually self-evident.
If a model has several distinct types of components, you will need to
specify which components to return.
}
\details{
Tidy \code{gam} objects created by calls to \code{\link[mgcv:gam]{mgcv::gam()}} with
\code{\link[=tidy.gam]{tidy.gam()}}.
}
\examples{

library(gam)
g <- gam(mpg ~ s(hp, 4) + am + qsec, data = mtcars)
  
tidy(g)
glance(g)

}
\seealso{
\code{\link[=tidy]{tidy()}}, \code{\link[gam:gam]{gam::gam()}}, \code{\link[=tidy.anova]{tidy.anova()}}, \code{\link[=tidy.gam]{tidy.gam()}}

Other gam tidiers: 
\code{\link{glance.Gam}()}
}
\concept{gam tidiers}
