% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats-loess-tidiers.R
\name{augment.loess}
\alias{augment.loess}
\alias{loess_tidiers}
\title{Tidy a(n) loess object}
\usage{
\method{augment}{loess}(x, data = model.frame(x), newdata = NULL, se_fit = FALSE, ...)
}
\arguments{
\item{x}{A \code{loess} objects returned by \code{\link[stats:loess]{stats::loess()}}.}

\item{data}{A \link[base:data.frame]{base::data.frame} or \code{\link[tibble:tibble]{tibble::tibble()}} containing the original
data that was used to produce the object \code{x}. Defaults to
\code{stats::model.frame(x)} so that \code{augment(my_fit)} returns the augmented
original data. \strong{Do not} pass new data to the \code{data} argument.
Augment will report information such as influence and cooks distance for
data passed to the \code{data} argument. These measures are only defined for
the original training data.}

\item{newdata}{A \code{\link[base:data.frame]{base::data.frame()}} or \code{\link[tibble:tibble]{tibble::tibble()}} containing all
the original predictors used to create \code{x}. Defaults to \code{NULL}, indicating
that nothing has been passed to \code{newdata}. If \code{newdata} is specified,
the \code{data} argument will be ignored.}

\item{se_fit}{Logical indicating whether or not a \code{.se.fit} column should be
added to the augmented output. For some models, this calculation can be
somwhat time-consuming. Defaults to \code{FALSE}.}

\item{...}{Additional arguments. Not used. Needed to match generic
signature only. \strong{Cautionary note:} Misspelled arguments will be
absorbed in \code{...}, where they will be ignored. If the misspelled
argument has a default value, the default value will be used.
For example, if you pass \code{conf.lvel = 0.9}, all computation will
proceed using \code{conf.level = 0.95}. Additionally, if you pass
\code{newdata = my_tibble} to an \code{\link[=augment]{augment()}} method that does not
accept a \code{newdata} argument, it will use the default value for
the \code{data} argument.}
}
\description{
Tidy summarizes information about the components of a model.
A model component might be a single term in a regression, a single
hypothesis, a cluster, or a class. Exactly what tidy considers to be a
model component varies across models but is usually self-evident.
If a model has several distinct types of components, you will need to
specify which components to return.
}
\details{
When the modeling was performed with \code{na.action = "na.omit"}
(as is the typical default), rows with NA in the initial data are omitted
entirely from the augmented data frame. When the modeling was performed
with \code{na.action = "na.exclude"}, one should provide the original data
as a second argument, at which point the augmented data will contain those
rows (typically with NAs in place of the new columns). If the original data
is not provided to \code{\link[=augment]{augment()}} and \code{na.action = "na.exclude"}, a
warning is raised and the incomplete rows are dropped.

Note that \code{loess} objects by default will not predict on data
outside of a bounding hypercube defined by the training data unless the
original \code{loess} object was fit with
\verb{control = loess.control(surface = \\"direct\\"))}. See
\code{\link[stats:predict.loess]{stats::predict.loess()}} for details.
}
\examples{

lo <- loess(
  mpg ~ hp + wt,
  mtcars,
  control = loess.control(surface = "direct")
)

augment(lo)

# with all columns of original data
augment(lo, mtcars)

# with a new dataset
augment(lo, newdata = head(mtcars))
}
\seealso{
\link[stats:na.action]{stats::na.action}

\code{\link[=augment]{augment()}}, \code{\link[stats:loess]{stats::loess()}}, \code{\link[stats:predict.loess]{stats::predict.loess()}}
}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}} with columns:
  \item{.fitted}{Fitted or predicted value.}
  \item{.resid}{The difference between observed and fitted values.}
  \item{.se.fit}{Standard errors of fitted values.}

}
