% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bruceR-stats_1_basic.R
\name{Freq}
\alias{Freq}
\title{Frequency statistics.}
\usage{
Freq(x, varname, labels, sort = "", digits = 1, file = NULL)
}
\arguments{
\item{x}{A vector of values (or a data frame).}

\item{varname}{[Optional] Variable name, if \code{x} is a data frame.}

\item{labels}{[Optional] A vector re-defining the labels of values.}

\item{sort}{\code{""} (default, sorted by the order of variable values/labels), \code{"-"} (decreasing by N), or \code{"+"} (increasing by N).}

\item{digits}{Number of decimal places of output. Defaults to \code{1}.}

\item{file}{File name of MS Word (\code{".doc"}).}
}
\value{
A data frame of frequency statistics.
}
\description{
Frequency statistics.
}
\examples{
data = psych::bfi

## Input `data$variable`
Freq(data$education)
Freq(data$gender, labels=c("Male", "Female"))
Freq(data$age)

## Input one data frame and one variable name
Freq(data, "education")
Freq(data, "gender", labels=c("Male", "Female"))
Freq(data, "age")

}
