% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auth_pass.R
\name{set_bluesky_pass}
\alias{set_bluesky_pass}
\alias{bs_set_pass}
\title{Add Entry to Renviron}
\usage{
set_bluesky_pass(pass, overwrite = FALSE, install = FALSE, r_env = NULL)

bs_set_pass(pass, overwrite = FALSE, install = FALSE, r_env = NULL)
}
\arguments{
\item{pass}{Character. App Password to add to add.}

\item{overwrite}{Defaults to FALSE. Boolean. Should existing \code{BLUESKY_APP_PASS} in Renviron be overwritten?}

\item{install}{Defaults to FALSE. Boolean. Should this be added '~/.Renviron' file?}

\item{r_env}{Path to install to if \code{install} is \code{TRUE}.}
}
\value{
pass, invisibly
}
\description{
Adds Bluesky App Password to .Renviron.
}
\examples{
example_env <- tempfile(fileext = '.Renviron')
set_bluesky_pass('1234-1234-1234-1234', r_env = example_env)
# r_env should likely be: file.path(Sys.getenv('HOME'), '.Renviron')
}
\concept{auth}
