% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcp.R
\name{mcp}
\alias{mcp}
\alias{btw_mcp_server}
\alias{btw_mcp_session}
\title{Start a Model Context Protocol server with btw tools}
\usage{
btw_mcp_server(tools = btw_tools())

btw_mcp_session()
}
\arguments{
\item{tools}{A list of \code{\link[ellmer:tool]{ellmer::tool()}}s to use in the MCP server, defaults
to the tools provided by \code{\link[=btw_tools]{btw_tools()}}. Use \code{\link[=btw_tools]{btw_tools()}} to subset to
specific list of \pkg{btw} tools that can be augmented with additional
tools. Alternatively, you can pass a path to an R script that returns a
list of tools as supported by \code{\link[mcptools:server]{mcptools::mcp_server()}}.}
}
\value{
Returns the result of \code{\link[mcptools:server]{mcptools::mcp_server()}} or
\code{\link[mcptools:server]{mcptools::mcp_session()}}.
}
\description{
\code{btw_mcp_server()} starts an MCP server with tools from \code{\link[=btw_tools]{btw_tools()}}, which
can provide MCP clients like Claude Desktop or Claude Code with additional
context. The function will block the R process it's called in and isn't
intended for interactive use.

To give the MCP server access to a specific R session, run \code{btw_mcp_session()}
in that session. If there are no sessions configured, the server will run
the tools in its own session, meaning that e.g. the
\code{btw_tools(tools = "env")} tools will describe R objects in \emph{that} R
environment.
}
\section{Configuration}{

To configure this server with MCP clients, use the command \code{Rscript} and the
args \verb{-e "btw::btw_mcp_server()"}. For example, in \href{https://docs.claude.com/en/docs/claude-code/mcp#add-mcp-servers-from-json-configuration}{Claude Desktop's configuration format}:

\if{html}{\out{<div class="sourceCode json">}}\preformatted{\{
  "mcpServers": \{
    "r-btw": \{
      "command": "Rscript",
      "args": ["-e", "btw::btw_mcp_server()"]
    \}
  \}
\}
}\if{html}{\out{</div>}}

For \href{https://docs.claude.com/en/docs/claude-code/overview}{Claude Code}:

\if{html}{\out{<div class="sourceCode bash">}}\preformatted{claude mcp add -s "user" r-btw -- Rscript -e "btw::btw_mcp_server()"
}\if{html}{\out{</div>}}

For \href{https://www.continue.dev/}{Continue}, include the following in your
\href{https://docs.continue.dev/customize/deep-dives/configuration}{config file}:

\if{html}{\out{<div class="sourceCode json">}}\preformatted{"experimental": \{
  "modelContextProtocolServers": [
    \{
      "transport": \{
        "name": "r-btw",
        "type": "stdio",
        "command": "Rscript",
        "args": [
          "-e",
          "btw::btw_mcp_server()"
        ]
      \}
    \}
  ]
\}
}\if{html}{\out{</div>}}
}

\section{Additional Examples}{


\code{btw_mcp_server()} should only be run non-interactively, as it will block the
current R process once called.

To start a server with btw tools:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{btw_mcp_server()
}\if{html}{\out{</div>}}

Or to only do so with a subset of btw's tools, e.g. those that fetch package
documentation:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{btw_mcp_server(tools = btw_tools("docs"))
}\if{html}{\out{</div>}}

To allow the server to access variables in specific sessions, call
\code{btw_mcp_session()} in that session:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{btw_mcp_session()
}\if{html}{\out{</div>}}
}

\examples{
# btw_mcp_server() and btw_mcp_session() are only intended to be run in
# non-interactive R sessions, e.g. when started by an MCP client like
# Claude Desktop or Claude Code. Therefore, we don't run these functions
# in examples.

# See above for more details and examples.

}
\seealso{
These functions use \code{\link[mcptools:server]{mcptools::mcp_server()}} and \code{\link[mcptools:server]{mcptools::mcp_session()}}
under the hood. To configure arbitrary tools with an MCP client, see the
documentation of those functions.
}
