% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redundancy.R
\name{redundancy}
\alias{redundancy}
\alias{print.cancor.redundancy}
\title{Canonical Redundancy Analysis}
\usage{
redundancy(object, ...)

\method{print}{cancor.redundancy}(x, digits = max(getOption("digits") - 3, 3), ...)
}
\arguments{
\item{object}{A \code{"cancor"} object}

\item{\dots}{Other arguments}

\item{x}{A \code{"cancor.redundancy"} for the \code{print} method.}

\item{digits}{Number of digits to print}
}
\value{
An object of class \code{"cancor.redundancy"}, a list with the 
following 5 components:
   \item{Xcan.redun}{Canonical redundancies for the X variables, i.e., the
      total fraction of X variance accounted for by the Y variables through each
      canonical variate.} 
\item{Ycan.redun}{Canonical redundancies for the Y variables} 
\item{X.redun}{Total canonical redundancy for the X variables,
      i.e., the sum of \code{Xcan.redun}.} 
\item{Y.redun}{Total canonical redundancy for the Y variables} 
\item{set.names}{names for the X and Y sets of variables}
}
\description{
Calculates indices of redundancy (Stewart & Love, 1968) from a canonical
correlation analysis. These give the proportion of variances of the
variables in each set (X and Y) which are accounted for by the variables in
the other set through the canonical variates.
}
\details{
The term "redundancy analysis" has a different interpretation and implementation in the
environmental ecology literature, such as the \pkg{vegan}.
In that context, each \eqn{Y_i} variable is regressed separately on the predictors in \eqn{X},
to give fitted values \eqn{\widehat{Y} = [\widehat{Y}_1, \widehat{Y}_2, \dots}.
Then a PCA of \eqn{\widehat{Y}} is carried out to determine a reduced-rank structure of 
the predictions.
}
\section{Functions}{
\itemize{
\item \code{print(cancor.redundancy)}: \code{print()} method for \code{"cancor.redundancy"} objects.

}}
\examples{

	data(Rohwer, package="heplots")
X <- as.matrix(Rohwer[,6:10])  # the PA tests
Y <- as.matrix(Rohwer[,3:5])   # the aptitude/ability variables

cc <- cancor(X, Y, set.names=c("PA", "Ability"))

redundancy(cc)
## 
## Redundancies for the PA variables & total X canonical redundancy
## 
##     Xcan1     Xcan2     Xcan3 total X|Y 
##   0.17342   0.04211   0.00797   0.22350 
## 
## Redundancies for the Ability variables & total Y canonical redundancy
## 
##     Ycan1     Ycan2     Ycan3 total Y|X 
##    0.2249    0.0369    0.0156    0.2774 


}
\references{
Muller K. E. (1981).
Relationships between redundancy analysis, canonical correlation, and multivariate regression. 
\emph{Psychometrika}, \bold{46}(2), 139-42.

Stewart, D. and Love, W. (1968). A general canonical correlation
index.  \emph{Psychological Bulletin}, 70, 160-163.

Brainder, "Redundancy in canonical correlation analysis", 
\url{https://brainder.org/2019/12/27/redundancy-in-canonical-correlation-analysis/}
}
\seealso{
\code{\link{cancor}}
}
\author{
Michael Friendly
}
\keyword{multivariate}
