set.seed(1)
test_that("pca_predictors - normal path", {
  sa <- sdm_area(parana, 1)
  sa <- add_predictors(sa, bioc)
  sa <- select_predictors(sa, c("bio1", "bio12"))
  sa <- sa |> dplyr::mutate(div=bio1/bio12, prod=bio1*bio12, sub=bio12-bio1, soma=bio1+bio12)
  sa <- add_scenarios(sa)
  oc <- occurrences_sdm(occ, crs=6933)
  oc <- join_area(oc, sa)
  i <- input_sdm(oc, sa)
  expect_error(get_pca_model(i))
  i <- pca_predictors(i)
  expect_true("variable_selection" %in% names(i$predictors))
  expect_true("pca" %in% names(i$predictors$variable_selection))
  expect_true(any(get_predictor_names(i)[-c(1:6)] %in% i$predictors$variable_selection$pca$selected_variables))
  expect_true(all(get_predictor_names(i)[-c(1:6)] %in% colnames(i$scenarios$data$current)))
  #skip_on_cran()
  #expect_snapshot(pca_summary(i))
  val <- pca_summary(i)
  expect_equal(val$importance[,1] |> as.numeric() |> round(4), c(541.63490, 0.99470, 0.99470))
  expect_equal(val$sdev |> round(3), c(541.635, 39.571, 0.188, 0.000, 0.000, 0.000))
  expect_equal(as.numeric(val$rotation[,1]) |> round(4), c(-0.00130, -0.02960, 0.00000, -0.99870, -0.02830, -0.03090))
  expect_equal(as.numeric(val$x[1,]) |> round(4), c(33.80090, 46.81440, 0.16050, -0.00000, 0.0000, 0.0000))
  expect_equal(as.numeric(val$center) |> round(3), c(20.2420, 289.7240, 0.0710, 5840.4060, 269.4820, 309.9660))
  expect_equal(class(get_pca_model(i)), "prcomp")
})

test_that("pca_predictors - without scenarios", {
  sa <- sdm_area(parana, 1)
  sa <- add_predictors(sa, bioc)
  sa <- select_predictors(sa, c("bio1", "bio12"))
  sa <- sa |> dplyr::mutate(div=bio1/bio12, prod=bio1*bio12, sub=bio12-bio1, soma=bio1+bio12)
  oc <- occurrences_sdm(occ, crs=6933)
  oc <- join_area(oc, sa)
  i <- input_sdm(oc, sa)
  expect_error(get_pca_model(i))
  i <- pca_predictors(i)
  expect_true("variable_selection" %in% names(i$predictors))
  expect_true("pca" %in% names(i$predictors$variable_selection))
  expect_true(any(get_predictor_names(i)[-c(1:6)] %in% i$predictors$variable_selection$pca$selected_variables))
  expect_true(all(get_predictor_names(i)[-c(1:6)] %in% colnames(i$scenarios$data$current)))
  #skip_on_cran()
  #expect_snapshot(pca_summary(i))
  val <- pca_summary(i)
  expect_equal(val$importance[,1] |> as.numeric() |> round(4), c(541.63490, 0.99470, 0.99470))
  expect_equal(val$sdev |> round(3), c(541.635, 39.571, 0.188, 0.000, 0.000, 0.000))
  expect_equal(as.numeric(val$rotation[,1]) |> round(4), c(-0.00130, -0.02960, 0.00000, -0.99870, -0.02830, -0.03090))
  expect_equal(as.numeric(val$x[1,]) |> round(4), c(33.80090, 46.81440, 0.16050, -0.00000, 0.00000, 0.00000))
  expect_equal(as.numeric(val$center) |> round(3), c(20.2420, 289.7240, 0.0710, 5840.4060, 269.4820, 309.9660))
  expect_equal(class(get_pca_model(i)), "prcomp")
})
