% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chirps.R
\docType{package}
\name{chirps}
\alias{chirps}
\alias{chirps-package}
\title{API Client for CHIRPS and CHIRTS}
\description{
API Client for the Climate Hazards Center 'CHIRPS' and 'CHIRTS'. The 'CHIRPS' data is a quasi-global (50°S – 50°N) high-resolution (0.05 arc-degrees) rainfall data set, which incorporates satellite imagery and in-situ station data to create gridded rainfall time series for trend analysis and seasonal drought monitoring. 'CHIRTS' is a quasi-global (60°S – 70°N), high-resolution data set of daily maximum and minimum temperatures. For more details on 'CHIRPS' and 'CHIRTS' data please visit its official home page <https://www.chc.ucsb.edu/data>.
}
\note{
While \CRANpkg{chirps} does not redistribute the data or provide it in any
 way, we encourage users to cite Funk et al. (2015) when using
 \acronym{CHIRPS} and Funk et al. (2019) when using \acronym{CHIRTS}.

Funk et al. (2015). Scientific Data, 2, 150066. 
\doi{10.1038/sdata.2015.66}

Funk et al. (2019). Journal of Climate, 32(17), 5639–5658. 
\doi{10.1175/JCLI-D-18-0698.1}
}
\seealso{
\strong{Useful links:}
\itemize{
\item{JOSS paper: 
 \doi{10.21105/joss.02419}}
\item{Development repository: 
 \url{https://github.com/ropensci/chirps}}
\item{Static documentation: 
 \url{https://docs.ropensci.org/chirps/}}
\item{Report bugs: 
 \url{https://github.com/ropensci/chirps/issues}}
\item{CHC website: 
 \url{https://www.chc.ucsb.edu}}
}
}
\author{
Kauê de Sousa and Adam H. Sparks and Aniruddha Ghosh
}
