% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/newdata_xifti.R
\name{newdata_xifti}
\alias{newdata_xifti}
\title{Replace the data in a \code{"xifti"}}
\usage{
newdata_xifti(xifti, newdata, newnames = NULL, subcortex_by_bs = FALSE)
}
\arguments{
\item{xifti}{A \code{"xifti"} object.}

\item{newdata}{The \eqn{V \times T} matrix of data values to replace those
in \code{xifti} with. The left cortex vertices should be at the top, right
cortex vertices in the middle, and subcortex vertices at the bottom (when
present).

If \code{newdata} is instead a \eqn{V \times Q} matrix where \eqn{Q} is not
\eqn{T}, then any column names or label tables will be removed.
(A "dlabel" will be converted to a "dscalar".)

Can also be a length-one vector to set all values equally.}

\item{newnames}{Replaces the names in the \code{xifti}. If \code{NULL}
(default), keep the original names, except if the number of columns
in \code{newdata} doesn't match that of \code{xifti}, in which case
no names will be used.}

\item{subcortex_by_bs}{If subcortical data is being provided in
\code{newdata}, are the locations ordered by brain structure? Default:
\code{FALSE}. The \code{"xifti"} data matrix is not ordered by brain
structure, but CIFTI files and most other CIFTI packages do sort subcortical
data by brain structure first, and then array index second.}
}
\value{
The new \code{"xifti"}
}
\description{
Replace the data in a \code{"xifti"} with new data from a data matrix.
}
\details{
If the \code{"xifti"} has \eqn{V} grayordinates and \eqn{T} measurements\,
\code{newdata} should be a \eqn{V \times Q} matrix. If \eqn{Q}
is not equal to \eqn{T}, then any column names or label tables will be
removed. (A "dlabel" will be converted to a "dscalar".)
}
\seealso{
Other manipulating xifti: 
\code{\link{add_surf}()},
\code{\link{apply_parc}()},
\code{\link{apply_xifti}()},
\code{\link{combine_xifti}()},
\code{\link{convert_xifti}()},
\code{\link{impute_xifti}()},
\code{\link{merge_xifti}()},
\code{\link{move_to_mwall}()},
\code{\link{move_to_submask}()},
\code{\link{remap_cifti}()},
\code{\link{remove_xifti}()},
\code{\link{resample_cifti}()},
\code{\link{resample_cifti_from_template}()},
\code{\link{scale_xifti}()},
\code{\link{select_xifti}()},
\code{\link{set_names_xifti}()},
\code{\link{smooth_cifti}()},
\code{\link{transform_xifti}()}
}
\concept{manipulating xifti}
