\name{fitPacs}

\alias{fitPacs}

\title{fitPacs function}

\description{
  This function implements the PACS (Pairwise Absolute Clustering and
  Sparsity) methodology of Sharma DB et al. (2013). This methodology
  proposes to estimate the regression coefficients by solving a penalized
  least squares problem.  It imposes a constraint on Beta (the vector of
  regression coefficients) that is a weighted combination of the L1 norm
  and the pairwise L-infinity norm.  Upper-bounding the pairwise
  L-infinity norm enforces the covariates to  have  close  coefficients.
  When  the  constraint  is  strong  enough,  closeness  translates
  into equality achieving thus a grouping property.  For PACS, no
  software was available.  Only an R script was released on Bondell's
  webpage (http://www4.stat.ncsu.edu/~bondell/Software/PACS/PACS.R.r).
  Since this R script was running very slowly, we decided to reimplement
  it in C++ and interfaced it with the present R package clere.
}

\usage{
   fitPacs(Y = rnorm(10), X = matrix(rnorm(50), nrow = 10),
           lambda=0.5,betaInput=rnorm(10),epsPACS=1e-5,nItMax=1000)
}

\arguments{
  \item{Y}{[numeric]: The vector of observed responses - size \code{n}.}
  \item{X}{[matrix]: The matrix of predictors - size \code{n} rows and \code{p} columns.}
  \item{lambda}{[numeric]: A non-negative penalty term that controls simultaneouly clusetering and sparsity.}
  \item{betaInput}{[numeric]: A vector of initial guess of the model parameters. The authors suggest to use coefficients obtained after fitting a ridge regression with the shrinkage parameter selected using AIC criterion.}
  \item{epsPACS}{[numeric]: A tolerance threshold that control the convergence of the algroithm. The default value fixed in Bondell's initial script is 1e-5.}
  \item{nItMax}{[numeric]: Maximum number of iterations in the algorithm.}
}

\value{
  Object of class \code{\linkS4class{Pacs}} containing all the input
  parameters plus parameter \code{a0} the intercept and parameter \code{K} the
  dimensionality of the model.
}

\seealso{
  Overview  : \code{\link{clere-package}} \cr
  Classes   : \code{\linkS4class{Clere}} \cr
  Methods   :  \code{\link{show}}, \code{\link{plot}}, \code{\link{clusters}}, \code{\link{predict}}, \code{\link{summary}} \cr
  Functions : \code{\link{fitClere}} \code{\link{fitPacs}}
}

\author{Loic Yengo (re-implementation of Bondell's script) \email{loic.yengo@gmail.com}}

\keyword{fitPacs}
\keyword{fitClere}
\keyword{Clere}
\keyword{clere}
\keyword{function}

\examples{
  n    <- 100
  p    <-  20
  Beta <- rep(c(0,2),10)
  eps  <- rnorm(n,sd=3)
  x    <- matrix(rnorm(n*p), nrow = n, ncol = p)
  y    <- as.numeric(10+x\%*\%Beta+eps)
  mod  <- fitPacs(Y=y,X=x,lambda=1.25,betaInput=rnorm(p,mean=Beta),epsPACS=1e-5,nItMax=1000)
}
