% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hydro_imgw_datastore.R
\name{hydro_imgw_datastore}
\alias{hydro_imgw_datastore}
\title{IMGW hydrological data from the IMGW datastore repository}
\usage{
hydro_imgw_datastore(
  year,
  parameters = NULL,
  stations = NULL,
  coords = TRUE,
  allow_failure = TRUE
)
}
\arguments{
\item{year}{numeric vector of years to be downloaded (e.g., 2022:2023)}

\item{parameters}{\itemize{
\item character vector describing which parameters to be downloaded. Default \code{NULL} means to download all available.
\enumerate{
\item "level" - Water level (operational) (cm)
\item "level_obs" - Water level (observer) (cm)
\item "flow" - Water flow rate (operational) (m3/s)
\item "temp" - Water temperature (observer) (degree C)
}
}}

\item{stations}{\itemize{
\item character vector with station name(s) as visible in the \code{hydro_imgw_telemetry_stations()}.
Default \code{NULL} means to download data for all available stations.
}}

\item{coords}{\itemize{
\item logical - whether to append the dataset with station full name, longitude, latitude and altitude. Default: TRUE
}}

\item{allow_failure}{logical - whether to proceed or stop on failure. By default set to TRUE (i.e. don't stop on error). For debugging purposes change to FALSE}
}
\value{
data.table with a raw hydrorological measurements in 10-min or 60-min intervals.
Please note that this dataset is not validated by experts and may contain invalid values.
}
\description{
Downloading hourly and sub-hourly (hydrological) data from the telemetric stations
available in the danepubliczne.imgw.pl/datastore collection since 2008.
Most parameters are collected with 10 minutes interval and thus it is recommended to download only the mandatory years, parameters or stations.
For example, 1 year of data with all available parameters requires processing around 2-4GB of uncompressed data.
}
\details{
Data from the IMGW automated (telemetry) systems are non validated by experts and may contain invalid values.
}
\examples{
\donttest{
imgw_hydro_telemetry = hydro_imgw_datastore(year = 2022,
                                            parameters = "flow",
                                            stations = "FORDON",
                                            coords = TRUE)
}

}
