% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{clustermole_overlaps}
\alias{clustermole_overlaps}
\title{Perform cell type overrepresentation analysis for a set of genes}
\usage{
clustermole_overlaps(genes, species)
}
\arguments{
\item{genes}{A vector of genes.}

\item{species}{Species: "hs" for human or "mm" for mouse.}
}
\value{
A data frame of enrichment results with hypergeometric test p-values.
}
\description{
Perform cell type overrepresentation analysis for a set of genes
}
\examples{
my_genes <- c("CD2", "CD3D", "CD3E", "CD3G", "TRAC", "TRBC2", "LTB")
my_overlaps <- clustermole_overlaps(genes = my_genes, species = "hs")
head(my_overlaps)
}
