% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cogmapr-comp.R
\name{RelationshipTest}
\alias{RelationshipTest}
\title{Compare relationships weight between maps}
\usage{
RelationshipTest(
  project,
  units,
  output = "p.value",
  weighted.icm = FALSE,
  sep = ">",
  coder = "qcoder"
)
}
\arguments{
\item{project}{A QDA project, a list as generated by the ProjectCMap function.}

\item{units}{The units to compare}

\item{output}{"p.value" (default) or "raw.data".}

\item{weighted.icm}{A boolean. If FALSE, the weight of the relationships in the ICM will be fixed to 1.}

\item{sep}{(==Depreciated, with RQDA project==) A character string (often a single character) that is used in RQDA in order to express the relationships between two variables. Default is "_" if codes used in RQDA are of the form : "x_y" (\emph{i.e.} relationship from x to y), but it is possible to use ">", "->", "-->" or even "--->"}

\item{coder}{A character string indicating the coding tool used for coding the QDA. The only tool supported now is 'qcoder'. Earlier version of cogmapr worked with "RQDA" project (no more maintened).}
}
\value{
A data frame (if output = "p.value"), a list of data frame (if output = "raw.data").
}
\description{
This function test the differences between the properties of relationships
}
\details{
This function test the differences between the weight of relationships between groups of documents (i.e. between social cognitive maps). Till now, only two excluding groups can be tested (ex. document from one country vs another country, from a group of players vs another group of players). It is not possible to compare non exclusive groups (ex. map from one country vs map from one group of players, as some documents can be in the two groups!). For this test, the 'fisher.test' is done. If output = 'p.value', the function returns the results of the tests, one test for each relationships of the map. If output = 'raw.data', the function returns the raw data on which the tests are done, one data frame by concept. This option can be used to export data and perform other statistical tests.

If more then 2 groups, 'anova' can be used as test (to be confirmed).
}
\examples{
project_name <- "a_new_project"
main_path <- paste0(system.file("testdata", package = "cogmapr"), '/')
my.project <- ProjectCMap(main_path, project_name)

## need more documents
RelationshipTest(my.project, units = c("Belgium", "Québec"))
}
