% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{debug_contr_error}
\alias{debug_contr_error}
\title{Debug contrast errors in ANOVA-like models}
\usage{
debug_contr_error(dat, subset_vec = NULL)
}
\arguments{
\item{dat}{A data frame of predictors.}

\item{subset_vec}{Optional logical or numeric index vector used to subset rows before checks.}
}
\value{
A list with two elements:
\describe{
\item{nlevels}{Integer vector giving the number of levels for each factor
variable in \code{dat}.}
\item{levels}{List of factor level labels for each factor variable in
\code{dat}.}
}
}
\description{
Debug contrast errors in ANOVA-like models
}
\examples{
\donttest{
dat <- data.frame(
  group = factor(rep(letters[1:3], each = 3)),
  score = rnorm(9)
)

debug_contr_error(dat = dat)
}
}
