% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ComputeMutualInformation.R
\name{getMIBi}
\alias{getMIBi}
\title{Calculate Joint Mutual Information}
\usage{
getMIBi(x_1, x_2, x_3, bin = 6, sp_order = 2)
}
\arguments{
\item{x_1}{A numeric vector for the first variable.}

\item{x_2}{A numeric vector for the second variable. Must match the length of `x_1`.}

\item{x_3}{A numeric vector for the third variable. Must match the length of `x_1`.}

\item{bin}{An integer specifying the number of bins. Default is 6.}

\item{sp_order}{An integer specifying the spline order. Must be less than `bin`. Default is 2.}
}
\value{
A numeric value representing joint mutual information (MI).
}
\description{
Computes the joint mutual information I(x_1, x_2; x_3)
using the specified number of bins and spline order.
}
\examples{
x_1 <- rnorm(100)
x_2 <- rnorm(100)
x_3 <- rnorm(100)
getMIBi(x_1, x_2, x_3)

}
