% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbi-methods.R
\docType{class}
\name{DBI}
\alias{DBI}
\alias{connConnection-class}
\alias{dbWriteTable,connConnection,ANY-method}
\alias{dbSendQuery,connConnection-method}
\title{DBI methods}
\usage{
\S4method{dbWriteTable}{connConnection,ANY}(conn, name, value, ...)

\S4method{dbSendQuery}{connConnection}(conn, statement, ...)
}
\arguments{
\item{conn}{A \linkS4class{DBIConnection} object, as returned by
\code{\link[DBI:dbConnect]{dbConnect()}}.}

\item{name}{The table name, passed on to \code{\link[DBI:dbQuoteIdentifier]{dbQuoteIdentifier()}}. Options are:
\itemize{
\item a character string with the unquoted DBMS table name,
e.g. \code{"table_name"},
\item a call to \code{\link[DBI:Id]{Id()}} with components to the fully qualified table name,
e.g. \code{Id(schema = "my_schema", table = "table_name")}
\item a call to \code{\link[DBI:SQL]{SQL()}} with the quoted and fully qualified table name
given verbatim, e.g. \code{SQL('"my_schema"."table_name"')}
}}

\item{value}{a \link{data.frame} (or coercible to data.frame).}

\item{...}{Other parameters passed on to methods.}

\item{statement}{a character string containing SQL.}
}
\description{
Implementations of pure virtual functions defined in the `DBI` package.
}
\keyword{internal}
