% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extra_functions.R
\name{credset}
\alias{credset}
\title{Credible set of genetic variants}
\usage{
credset(pp, CV, thr)
}
\arguments{
\item{pp}{Vector of posterior probabilities of causality}

\item{CV}{Optional parameter: Index of CV}

\item{thr}{Minimum threshold for credible set size}
}
\value{
list of the variants in the credible set, the claimed.cov (cumulative sum of the posterior probabilities of the variants forming the credible set), binary covered indicator (1 if CV is contained in the credible set) and nvar (number of variants in the set)
}
\description{
Credible set of putative causal variants
}
\details{
If the CV parameter is supplied (index of causal variant) then the
output includes a binary indicator of whether the CV is contained in the set
}
\examples{

set.seed(1)
nsnps <- 100
pp <- rnorm(nsnps, 0.3, 0.05)
pp <- pp/sum(pp)

credset(pp, thr = 0.9)

iCV <- 71

credset(pp, CV = iCV, thr = 0.9)

}
\author{
Anna Hutchinson
}
