% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_rules.R
\name{h_info_theory_dist}
\alias{h_info_theory_dist}
\title{Calculating the Information Theoretic Distance}
\usage{
h_info_theory_dist(prob, target, asymmetry)
}
\arguments{
\item{prob}{(\code{numeric})\cr vector or matrix with probabilities of a DLT occurring.}

\item{target}{(\code{number })\cr single target probability of a DLT.}

\item{asymmetry}{(\code{number})\cr describes the rate of penalization
for overly toxic does, range 0 to 2.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Helper function which provides the value of the
divergence as given by equation in (7) in the reference at
https://doi.org/10.1002/sim.8450.
}
\examples{
h_info_theory_dist(c(0.5, 0.2), 0.4, 1.2)
}
