% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chart.R
\name{chart}
\alias{chart}
\title{Build an interactive financial chart}
\usage{
chart(
  ticker,
  main = kline(),
  sub = list(),
  indicator = list(),
  event_data = NULL,
  options = list()
)
}
\arguments{
\item{ticker}{An object with Open, High, Low, Close and Volume columns that
can be coerced to a \code{\link[xts:xts]{xts::xts()}}-object.}

\item{main}{A \code{\link[plotly:plot_ly]{plotly::plot_ly()}}-function. \code{\link[=kline]{kline()}} by default.}

\item{sub}{An optional \link{list} of \code{\link[plotly:plot_ly]{plotly::plot_ly()}}-function(s).}

\item{indicator}{An optional \link{list} of \code{\link[plotly:add_lines]{plotly::add_lines()}}-function(s).}

\item{event_data}{An optional \link{data.frame} with event line(s) to be added
to the \code{\link[=chart]{chart()}}. See \code{\link[=add_event]{add_event()}} for more details.}

\item{options}{An optional \link{list} of \code{\link[=chart]{chart()}}-options. See details below.}
}
\value{
A \code{\link[plotly:plot_ly]{plotly::plot_ly()}} object.

\strong{Sample Output}
\if{html}{
  \out{<span style="text-align: center; display: block;">}
  \figure{README-chartquote-1.png}{options: style="width:750px;max-width:75\%;"}\out{</span>}
}
\if{latex}{
  \out{\begin{center}}\figure{README-chartquote-1.png}\out{\end{center}}
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

A high-level \code{\link[plotly:plot_ly]{plotly::plot_ly()}}- and \code{\link[plotly:subplot]{plotly::subplot()}}-wrapper function
for building interactive financial charts using
the affiliated \link{chart}-functions. The \link{chart} consists of a main chart, and
an optional subchart. The main chart supports overlaying various trading
indicators like \link{sma} and \link{bollinger_bands}.
}
\details{
\subsection{Options}{
\itemize{
\item \code{dark} A <\link{logical}>-value of \link{length} 1. \link{TRUE} by default.
Sets the overall theme of the \code{\link[=chart]{chart()}}
\item \code{slider} A <\link{logical}>-value of \link{length} 1. \link{FALSE} by default.
If \link{TRUE}, a \code{\link[plotly:rangeslider]{plotly::rangeslider()}} is added.
\item \code{deficiency}  A <\link{logical}>-value of \link{length} 1. \link{FALSE} by default.
If \link{TRUE}, all \code{\link[=chart]{chart()}}-elements are colorblind friendly
\item \code{size} A <\link{numeric}>-value of \link{length} 1. The relative size of the
main chart. 0.6 by default. Must be between 0 and 1, non-inclusive.
\item \code{scale} A <\link{numeric}>-value of \link{length} 1. 1 by default. Scales
all fonts on the chart.
\item \code{width} A <\link{numeric}>-value of \link{length} 1. 0.9 by default. Sets
the width of all line elements on the chart.
\item \code{static} A <\link{logical}>-value of \link{length} 1. \link{FALSE} by default. If \link{FALSE}
the chart can be edited, annotated and explored interactively.
\item \code{palette} A <\link{character}>-vector of \link{length} 1. "hawaii" by default. See \code{\link[=hcl.pals]{hcl.pals()}} for
all possible color palettes.
}
}

\subsection{Charting Events}{

If \code{event_data} is passed, vertical eventlines with appropriate labels and
coloring are added to the \code{\link[=chart]{chart()}}.
This function is rigid, as it will fail if event, label and
index columns are not passed.

For more details please see \code{\link[=add_event]{add_event()}}.
}
}
\examples{
# script start;

# 1) charting weekly
# BTC using candlesticks
# and indicators
cryptoQuotes::chart(
  ticker     = BTC,
  main       = cryptoQuotes::kline(),
  sub        = list(
    cryptoQuotes::volume(),
    cryptoQuotes::macd()
  ),
  indicator = list(
    cryptoQuotes::bollinger_bands(),
    cryptoQuotes::sma(),
    cryptoQuotes::alma()
  ),
  options = list(
    dark       = TRUE,
    deficiency = FALSE
  )
)

# script end;
}
\seealso{
Other chart indicators: 
\code{\link{add_event}()},
\code{\link{alma}()},
\code{\link{bollinger_bands}()},
\code{\link{dema}()},
\code{\link{donchian_channel}()},
\code{\link{ema}()},
\code{\link{evwma}()},
\code{\link{fgi}()},
\code{\link{hma}()},
\code{\link{lsr}()},
\code{\link{macd}()},
\code{\link{rsi}()},
\code{\link{sma}()},
\code{\link{smi}()},
\code{\link{volume}()},
\code{\link{vwap}()},
\code{\link{wma}()},
\code{\link{zlema}()}

Other price charts: 
\code{\link{kline}()},
\code{\link{ohlc}()},
\code{\link{pline}()}
}
\author{
Serkan Korkmaz
}
\concept{chart indicators}
\concept{price charts}
