% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_trialTitle.R
\name{f.trialTitle}
\alias{f.trialTitle}
\title{Calculate the title of a study}
\usage{
f.trialTitle(df = NULL)
}
\arguments{
\item{df}{data frame such as from \link{dbGetFieldsIntoDf}. If `NULL`,
prints fields needed in `df` for calculating this trial concept, which can
be used with \link{dbGetFieldsIntoDf}.}
}
\value{
data frame with columns `_id` and `.trialTitle`, a string.
}
\description{
Trial concept calculated: scientific or full title of the study.
}
\examples{
# fields needed
f.trialTitle()

# apply trial concept when creating data frame
dbc <- nodbi::src_sqlite(
  dbname = system.file("extdata", "demo.sqlite", package = "ctrdata"),
  collection = "my_trials", flags = RSQLite::SQLITE_RO)
trialsDf <- dbGetFieldsIntoDf(
  calculate = "f.trialTitle",
  con = dbc)
trialsDf

}
