% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctDiscretePars.R
\name{ctStanDiscreteParsPlot}
\alias{ctStanDiscreteParsPlot}
\title{ctStanDiscreteParsPlot}
\usage{
ctStanDiscreteParsPlot(x, indices = "all", add = FALSE, legend = TRUE,
  polygon = TRUE, quantiles = c(0.025, 0.5, 0.975), times = seq(0, 10,
  0.1), latentNames = "auto", lwdvec = "auto", colvec = "auto",
  ltyvec = "auto", plotcontrol = list(ylab = "Value", xlab =
  "Time interval", main = "Regression coefficients", type = "l"), grid = TRUE,
  legendcontrol = list(x = "topright", bg = "white"), polygonalpha = 0.3,
  polygoncontrol = list(border = NA, steps = 20))
}
\arguments{
\item{x}{list object returned from \code{\link{ctStanDiscretePars}}.}

\item{indices}{Either a string specifying type of plot to create, or an n by 2
matrix specifying which indices of the output matrix to plot.
'AR' specifies all diagonals, for discrete time autoregression parameters.
'CR' specifies all off-diagonals,for discrete time cross regression parameters.
'all' plots all AR and CR effects at once.}

\item{add}{Logical. If FALSE, a new plot is generated, if TRUE, specified plot/s are
overlayed on existing plot.}

\item{legend}{Logical. If TRUE, generates a legend.}

\item{polygon}{Logical. If TRUE, fills a polygon between the first and last specified quantiles.}

\item{quantiles}{numeric vector of length 3, with values between 0 and 1, specifying which quantiles to plot.
The default of c(.05,.5,.95) plots 95\% credible intervals and the posterior median at 50\%.}

\item{times}{Numeric vector of positive values, discrete time parameters will be calculated for each.}

\item{latentNames}{Vector of character strings denoting names for the latent variables. 
'auto' just uses eta1 eta2 etc.}

\item{lwdvec}{Either 'auto', or a vector of positive integers denoting line widths for each quantile.
'auto' specifies c(1,3,1) if there are 3 quantiles to be plotted (default), otherwise simply 3.}

\item{colvec}{Either 'auto', or a vector of color values denoting colors for each index to be plotted.
'auto' generates colors using the \code{\link[grDevices]{rainbow}} function.}

\item{ltyvec}{Either 'auto', or a vector of line type integers (as for the lty parameter normally)
denoting line types for each quantile.
'auto' specifies c(3, 1, 3) if there are 3 quantiles to be plotted (default), otherwise simply 1.}

\item{plotcontrol}{list of arguments to pass to plot function. 
The following arguments are ignored: ylim,lwd,lty,col,x,y.}

\item{grid}{Logical. Plot with a grid?}

\item{legendcontrol}{list of arguments to pass to legend function. 'legend=' and 'text.col=' arguments
will be ignored.}

\item{polygonalpha}{Numeric between 0 and 1 to multiply the alpha (transparency) of colvec by for 
the fill polygon.}

\item{polygoncontrol}{list of arguments to pass to ctPoly function (if polygon=TRUE).
x,y, and col arguments will be ignored. Border is removed by default because quantile
borders are differently, and steps specifies the number of polygons to overlay to 
create a graduated transparency. Set to 1 for a flat looking plot.}
}
\description{
Plots model implied regression strengths at specified times for 
continuous time models fit with ctStanFit.
}
\examples{
x <- ctStanDiscretePars(ctstantestfit)

ctStanDiscreteParsPlot(x, 'CR')
}
