% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.ctStanModel.R
\name{plot.ctStanModel}
\alias{plot.ctStanModel}
\title{Prior plotting}
\usage{
\method{plot}{ctStanModel}(x, rows = "all", wait = FALSE, samples = 1e+06,
  hypersd = "marginalise", ...)
}
\arguments{
\item{x}{ctStanModel object as generated by \code{\link{ctModel}} with type='stanct' or 'standt'.}

\item{rows}{vector of integers denoting which rows of ctstanmodel$pars to plot priors for. 
Character string 'all' plots all rows with parameters to be estimated.}

\item{wait}{If true, user is prompted to continue before plotting next graph.}

\item{samples}{Numeric. Higher values increase fidelity (smoothness / accuracy) of density plots, at cost of speed.}

\item{hypersd}{Either 'marginalise' to sample from the specified (in the ctstanmodel) 
prior distribution for the population standard deviation, or a numeric value to use for the population standard deviation
for all subject level prior plots - the plots in dotted blue or red.}

\item{...}{not used.}
}
\description{
Plots priors for free model parameters in a ctStanModel.
}
\details{
Plotted in black is the prior for the population mean. In red and blue are the subject level priors that result
given that the population mean is estimated at 1 std deviation above the mean of the prior, or 1 std deviation below. 
The distributions around these two points are then obtained by marginalising over the prior for the population std deviation - 
so the red and blue distributions do not represent any specific subject level prior, but rather characterise the general amount
and shape of possible subject level priors at the selected points of the population mean prior.
}
