% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctDataHelp.R
\name{ctstantestdat}
\alias{ctstantestdat}
\title{ctstantestdat}
\format{matrix}
\description{
Generated dataset for testing \code{\link{ctStanFit}} from ctsem package.
}
\examples{
\dontrun{
Tpoints=20
n.manifest=2
n.TDpred=1
n.TIpred=3
n.latent=2
n.subjects=5
gm<-ctModel(type='omx', Tpoints=Tpoints,n.latent=n.latent,
n.TDpred=n.TDpred,n.TIpred=n.TIpred,n.manifest=n.manifest,
  MANIFESTVAR=diag(0.5,2),
  TIPREDEFFECT=matrix(c(.5,0,0,-.7,0,2),nrow=2),
  TIPREDVAR=matrix(c(1,-.2,0, 0,1,0, 0,0,.5),nrow=3),
  TDPREDVAR=matrix(0,nrow=n.TDpred*(Tpoints),ncol=n.TDpred*(Tpoints)),
  TDPREDMEANS=matrix(round(exp(rnorm(n.TDpred*(Tpoints),-1.9,1)),0),
   nrow=n.TDpred*(Tpoints)),
   TDPREDEFFECT = matrix(c(1,-1),ncol=1),
  LAMBDA=diag(1,2),
  DRIFT=matrix(c(-.3,.2,0,-.2),nrow=2),
  DIFFUSION=matrix(c(2,1,0,2),2),
  CINT=matrix(c(0,0),nrow=2),
  T0MEANS=matrix(0,ncol=1,nrow=2),
  T0VAR=diag(100,2))

ctstantestdat<-ctGenerate(gm,n.subjects=n.subjects,burnin=30,
wide=FALSE,logdtsd=.4)

ctstantestdat[2,'Y1'] <- NA
ctstantestdat[ctstantestdat[,'id']==2,'TI1'] <- NA
ctstantestdat[2,'TD1'] <- NA

save(ctstantestdat,file='.\\\\data\\\\ctstantestdat.rda')
}
}
