% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctFitAuto.R
\name{ctFitAuto}
\alias{ctFitAuto}
\title{ctFitAuto}
\usage{
ctFitAuto(
  m,
  dat,
  DRIFT = TRUE,
  DIFFUSION = TRUE,
  fast = FALSE,
  initialRestrictions = NA,
  individuals = FALSE,
  groupFreeThreshold = 0.5,
  cores = 2,
  ...
)
}
\arguments{
\item{m}{ctStan model object without time independent predictors.}

\item{dat}{Data in long format}

\item{DRIFT}{Logical, if TRUE, off diagonal drift parameters in the model are tested for inclusion}

\item{DIFFUSION}{Logical, if TRUE, off diagonal diffusion parameters in the model are tested for inclusion}

\item{fast}{Logical, if TRUE, do not compute uncertainty hessian / samples in individual level models.}

\item{initialRestrictions}{Alternative to the DRIFT / DIFFUSION arguments -- specify explicitly which parameters should be fixed initially, vector of integers based on the $setup$matsetup element of the ctStanFit object, which gives the parameter numbers. Primarily for internal use.}

\item{individuals}{Logical, if TRUE, fit individual level models and determine a group model based on the groupFreeThreshold argument.}

\item{groupFreeThreshold}{Numeric, threshold for group model structure -- if a parameter improves fit in this proportion of individuals or greater, it is freed for all individuals.}

\item{cores}{Number of CPU cores to use}

\item{...}{Additional arguments passed to ctStanFit}
}
\value{
A ctStan fit object
}
\description{
Fit a ctStan model with automatic parameter selection
}
\details{
This function is used to automatically select parameters in a ctStan model. Any specified DRIFT / DIFFUSION matrix off diagonals are only included if they significantly improve the likelihood, based on an estimated likelihood ratio test (relying on the Hessian).
}
\examples{
\dontrun{
testmodel <- ctstantestfit$ctstanmodelbase
testmodel$pars$TI1_effect <- NULL
testmodel$n.TIpred <- 0
testmodel$TIpredNames <- NULL
testfit <- ctFitAuto(testmodel, dat = ctstantestdat, DRIFT = TRUE, DIFFUSION = TRUE)
summary(testfit)
}
}
