% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctFitMultiModel.R
\name{ctFitMultiModel}
\alias{ctFitMultiModel}
\title{Fit and summarise a list of ctsem models}
\usage{
ctFitMultiModel(
  mlist,
  datalong,
  prefix = "",
  type = "stanct",
  cores = 2,
  summaryOutput = TRUE,
  saveFits = TRUE,
  summaryArgs = list(),
  ...
)
}
\arguments{
\item{mlist}{Named list of models}

\item{datalong}{ctsem long format data}

\item{prefix}{prefix for output files.}

\item{type}{'stanct' for continuous time or 'standt' for discrete time}

\item{cores}{number of cpu cores to use}

\item{summaryOutput}{Generate summary output into ctSummary folder? Large datasets can take some time.}

\item{saveFits}{Save fit objects to working directory?}

\item{summaryArgs}{Additional arguments for ctSummarise.}

\item{...}{Additional arguments for ctStanFit.}
}
\value{
List containing a named list of model fits ($fits), and a compare object ($compare)
}
\description{
Fit and summarise a list of ctsem models
}
\examples{
\dontrun{
if(w32chk()){
sunspots<-data.frame(id=1,
  time=do.call(seq,(lapply(attributes(sunspot.year)$tsp,function(x) x))),
  sunspots=sunspot.year)

 ssmodel1 <- ctModel(type='omx', manifestNames='sunspots', Tpoints=3,
  latentNames=c('ss_level', 'ss_velocity'),
   LAMBDA=matrix(c( 1, 'ma1| log(1+(exp(param)))' ), nrow=1, ncol=2),
   DRIFT=matrix(c(0, 'a21 | -log(1+exp(param))', 1, 'a22'), nrow=2, ncol=2),
   MANIFESTMEANS=matrix(c('m1|param * 10 + 44'), nrow=1, ncol=1),
   MANIFESTVAR=diag(0,1), #As per original spec
   CINT=matrix(c(0, 0), nrow=2, ncol=1),
   DIFFUSION=matrix(c(0, 0, 0, "diffusion"), ncol=2, nrow=2))
 
 ssmodel2 <- ssmodel1
 ssmodel2$LAMBDA[2] <- 0
 
 fits<-ctFitMultiModel(list(m1=ssmodel1,m2=ssmodel2),datalong = sunspots,
   summaryOutput = FALSE,saveFits = FALSE,cores=1)
 print(fits$compare)
}
}
}
