% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-algae.R
\name{Algae_TKTD}
\alias{Algae_TKTD}
\alias{AlgaeTKTD-class}
\alias{AlgaeTKTDScenario-class}
\title{Algae model with exponential growth, forcings (P, I) and scaled damage}
\usage{
Algae_TKTD()
}
\value{
an S4 object of type \linkS4class{AlgaeTKTD}
}
\description{
The model is a mechanistic combined toxicokinetic-toxicodynamic (TK/TD) and
growth model for algae. The model simulates the development of algal biomass
under laboratory and environmental conditions. The growth of the algae
population is simulated on the basis of growth rates, which are dependent on
environmental conditions (radiation, temperature and phosphorus).
The model is a variant of the \code{\link[=Algae_Weber]{Algae_Weber()}} model (Weber 2012) as cited
in EFSA TKTD opinion (2018). This Algae model, \code{\link[=Algae_TKTD]{Algae_TKTD()}}, provides an
additional possibility (probit) to simulate the dose-response curve and
considers a scaled internal damage instead of the external concentration.
}
\section{State variables}{

The model has four state variables:
\itemize{
\item \code{A}, Biomass (ug fresh wt/mL, cells/mL *10^4)
\item \code{Q}, Mass of phosphorous internal (ug P/ug fresh wt)
\item \code{P}, Mass of phosphorous external (ug P/L)
\item \code{Dw}, Damage concentration (ug/L)
}
}

\section{Model parameters}{

\itemize{
\item Growth model
\itemize{
\item \code{mu_max}, Maximum growth rate (d-1)
\item \code{Q_min}, Minimum intracellular P (ug P/ug fresh wt)
\item \code{Q_max}, Maximum intracellular P (ug P/ug fresh wt)
\item \code{v_max}, Maximum P-uptake rate at non-limited growth (ug P/ug fresh wt/d)
\item \code{k_s},   Half-saturation constant for extracellular P (mg P/L)
\item \code{m_max}, Natural mortality rate (1/d)
\item \code{I_opt}, Optimum light intensity for growth (uE/m²/s)
\item \code{T_opt}, Optimum temperature for growth (°C)
\item \code{T_max}, Maximum temperature for growth (°C)
\item \code{T_min}, Minimum temperature for growth (°C)
}
\item Concentration response (Toxicodynamics)
\itemize{
\item \code{EC_50}, Effect concentration of 50\% inhibition of growth rate (ug L-1)
\item \code{b}, slope of concentration effect curve at EC_50 (-)
\item \code{dose_resp}, shape of the dose response curve (0 = logit, 1 = probit)
}
\item External concentration (Toxicokinetics)
\itemize{
\item \code{kD}, dominant rate constant (d-1)
}
}
}

\section{Forcings}{

Besides exposure events (Cw), the \emph{Algae} model requires two environmental
properties as time-series input: Irradiance (\code{I}, uE/m²/s) and
temperature (\code{T_act}, deg C).
Forcings time-series are represented by \code{data.frame} objects
consisting of two columns. The first for time and the second for the
environmental factor in question. The input format for all forcings is a
list of the data frames.
}

\section{Simulation output}{

Simulation results will contain the state variables Biomass (\code{A}), mass of
internal phosphorous (\code{Q}), mass of external phosphorous (\code{P}) and the damage
concentration (\code{Dw}).

It is possible to amend the output of \code{\link[=simulate]{simulate()}} with additional model
quantities that are not state variables, for e.g. debugging purposes or to
analyze model behavior. To enable or disable additional outputs, use the
optional argument \code{nout} of \code{\link[=simulate]{simulate()}}. As an example, set \code{nout=2} to
enable reporting of model derivatives \code{dA} and \code{dQ}. Set \code{nout=0} to disable
additional outputs (default).

The available output levels are as follows:
\itemize{
\item Derivatives
\itemize{
\item \code{nout >= 1}: \code{dA}, biomass derivative (µg)
\item \code{nout >= 2}: \code{dQ}, internal phosphorous derivative (mg P/ug fresh wt)
\item \code{nout >= 3}: \code{dP}, external phosphorous derivative (mg P L-1)
\item \code{nout >= 4}: \code{dDw}, damage concentration derivative (ug L-1)
}
}
}

\section{Solver settings}{

The arguments to ODE solver \code{\link[deSolve:ode]{deSolve::ode()}} control how model equations
are numerically integrated. The settings influence stability of the numerical
integration scheme as well as numerical precision of model outputs. Generally, the
default settings as defined by \emph{deSolve} are used, but all \emph{deSolve} settings
can be modified in \emph{cvasi} workflows by the user, if needed. Please refer
to e.g. \code{\link[=simulate]{simulate()}} on how to pass arguments to \emph{deSolve} in \emph{cvasi}
workflows.

Some default settings of \emph{deSolve} were adapted for this model by expert
judgement to enable precise, but also computationally efficient, simulations
for most model parameters. These settings can be modified by the user,
if needed:
\itemize{
\item \code{hmax = 0.1}\if{html}{\out{<br>}}
Maximum step length in time suitable for most simulations.
}
}

\references{
Weber D, Schaeffer D, Dorgerloh M, Bruns E, Goerlitz G, Hammel K, Preuss TG
and Ratte HT, 2012. Combination of a higher-tier flow-through system and
population modeling to assess the effects of time-variable exposure of
isoproturon on the green algae Desmodesmus subspictatus and
Pseudokirchneriella subcapitata. Environmental Toxicology and
Chemistry, 31, 899-908. \doi{10.1002/etc.1765}
}
\seealso{
\link{Scenarios}, \link{Transferable}

Other algae models: 
\code{\link{Algae-models}},
\code{\link{Algae_Simple}()},
\code{\link{Algae_Weber}()}
}
\concept{algae models}
