% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvd_api_functions.R
\name{cvd_indicator_nationalarea_metric_data}
\alias{cvd_indicator_nationalarea_metric_data}
\title{Retrieve metric data for a specific area and for national (England) comparison}
\usage{
cvd_indicator_nationalarea_metric_data(time_period_id, area_id, metric_id)
}
\arguments{
\item{time_period_id}{Integer (required). The reporting period (time period) for which to retrieve metric data. Use \code{\link[=cvd_time_period_list]{cvd_time_period_list()}} to find valid IDs.}

\item{area_id}{Integer (required). The AreaID for which to retrieve data in addition to the national aggregate. use \code{\link[=cvd_area_list]{cvd_area_list()}} or \code{\link[=cvd_area_search]{cvd_area_search()}} to find valid IDs.}

\item{metric_id}{Integer (required). The MetricID for which to retrieve values. Use \code{\link[=cvd_indicator_metric_list]{cvd_indicator_metric_list()}} or \code{\link[=cvd_indicator_data]{cvd_indicator_data()}} to find valid MetricIDs.}
}
\value{
A named list with up to two tibbles:
\describe{
\item{area}{Tibble with one or more rows, summarising the metric for the specified area and the England aggregate (AreaID = 1).}
\item{target}{Tibble (if available) with target-setting details for the area}
}
If no data exists for both the area and the national aggregate for the given parameters, returns a tibble describing the error.

\strong{area} contains the following columns:
\describe{
\item{AreaCode}{Character. Code for the NHS area (e.g., "U68943" for Chester South PCN, "E92000001" for England).}
\item{AreaID}{Integer. Unique identifier for the NHS area.}
\item{AreaName}{Character. Name of the NHS area (e.g., "Chester South PCN", "England").}
\item{HighestPriorityNotificationType}{Character. Notification priority level, if applicable (e.g., "Red"). Often blank.}
\item{NationalLevel}{Character. Indicates whether the area represents national-level data ("Y" or "N").}
\item{NotificationCount}{Integer. Count of notifications associated with the area for the given metric.}
\item{Value}{Numeric. Final calculated value for the metric in the specified area.}
}

\strong{target} contains the following columns:
\describe{
\item{TargetLabel}{Character. Descriptive label for the target (e.g., "Upper threshold for QOF").}
\item{TargetPatients}{Integer. Number of additional patients needed to achieve the target threshold.}
\item{TargetValue}{Numeric. Target value or threshold to be achieved (e.g., 95).}
}
}
\description{
Returns a named list of tibbles containing: (1) metric data for the specified NHS area and the national (England, AreaID = 1) aggregate, and (2) details achieving the target value (if defined), including the target percentage and the additional number of patients needed to reach the target. This function supports benchmarking local performance vs. the national average, and helps quantify gaps to clinical targets.

If there is no data for either national or the chosen area for the given parameters, an error tibble is returned.
}
\details{
Use this function to benchmark a local area's metric value against the national figure and to understand the actual gap to a clinically meaningful target.
}
\note{
This function may take longer than 5 seconds to complete due to API response time.
}
\section{API Documentation}{

See the \href{https://bmchealthdocs.atlassian.net/wiki/spaces/CP/pages/317882369/CVDPREVENT+API+Documentation#\%2Findicator\%2FnationalAreaMetricData}{CVDPREVENT API documentation: Indicator national area metric data}
}

\examples{
\donttest{
# Compare performance against metric 150  (AF: treatment with anticoagulants
# - all people) in 'Chester South PCN' (area ID 553) with national
# performance:
returned_list <- cvd_indicator_nationalarea_metric_data(
    metric_id = 150,
    time_period_id = 17,
    area_id = 553
)

# See what the list contains
returned_list |> summary()

# Extract the `area` details
area_data <- returned_list$area
area_data

# Extract `target` details
target_data <- returned_list$target
target_data
}

}
\seealso{
\code{\link[=cvd_indicator_list]{cvd_indicator_list()}}, \code{\link[=cvd_indicator_metric_list]{cvd_indicator_metric_list()}}, \code{\link[=cvd_indicator_metric_data]{cvd_indicator_metric_data()}}, \code{\link[=cvd_indicator_data]{cvd_indicator_data()}}, \code{\link[=cvd_indicator_raw_data]{cvd_indicator_raw_data()}}, \code{\link[=cvd_area_list]{cvd_area_list()}}
}
