% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cwb.R
\name{cwb_install}
\alias{cwb_install}
\alias{cwb_get_url}
\alias{cwb_get_bindir}
\alias{cwb_is_installed}
\title{Utilities to install the Corpus Workbench (CWB)}
\usage{
cwb_install(
  url_cwb = cwb_get_url(),
  md5 = attr(url_cwb, "md5"),
  cwb_dir = fs::path(fs::path_temp(), "cwb"),
  verbose = TRUE
)

cwb_get_url()

cwb_get_bindir(bindir = Sys.getenv("CWB_BINDIR"), verbose = TRUE)

cwb_is_installed()
}
\arguments{
\item{url_cwb}{URL for downloading the CWB.}

\item{md5}{The md5 checksum of the compressed file to be downloaded.}

\item{cwb_dir}{The directory where the CWB shall be installed.}

\item{verbose}{Logical, whether to show progress messages.}

\item{bindir}{The directory with CWB binaries.}
}
\description{
The CWB comprises a set of command line tools for corpus preparation and
management. Functionality for installing and managing these Tools.
}
\details{
Use \code{cwb_install()} to download and install CWB binaries (v3.5) from
\href{https://cwb.sourceforge.io/}{SourceForge}. If successful, \code{cwb_install()}
returns the directory of the CWB, otherwiese \code{NULL}. For the installation
on macOS and Linux, see \url{https://cwb.sourceforge.io/install.php}.

\code{cwb_get_url()} will return the URL for downloading the appropriate
binary (Linux / macOS) of the CWB (v3.5), or the source tarball
(Linux). The md5 checksum of the file to be downloaded is part of the
return value as "md5" attribute.

\code{cwb_get_bindir()} detects the directory with the cwb command line
programs. Defaults to using the value of the environment
variable "CWB_BINDIR". If unset, the value of \code{cwb-config --bindir} is
used. Returns \code{NULL} if CWB installation is not found.

\code{cwb_is_installed()} will check whether the CWB is installed.
}
