% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixed_linear.R
\name{weibullmix}
\alias{weibullmix}
\alias{rweibullmix}
\alias{pweibullmix}
\alias{dweibullmix}
\alias{qweibullmix}
\title{Density, Distribution, Quantiles and Random Number Generation for the mixed Weibull
distribution}
\usage{
rweibullmix(n, shape, scale, prop)

dweibullmix(x, shape, scale, prop)

pweibullmix(q, shape, scale, prop)

qweibullmix(p, shape, scale, prop)
}
\arguments{
\item{n}{\link[base]{integer} value, the number of random samples to be
generated with \code{rweibullmix()}.}

\item{shape}{\link[base]{numeric} \link[base]{vector} holding the shape parameter
of the components.}

\item{scale}{\link[base]{numeric} \link[base]{vector} holding the scale parameter
of the components.}

\item{prop}{\link[base]{numeric} \link[base]{vector}, holding the mixing proportions
of the components.}

\item{x}{\link[base]{numeric} \link[base]{vector} giving the points where
the density function is evaluated.}

\item{q}{\link[base]{numeric} \link[base]{vector} giving the quantiles where
the distribution function is evaluated.}

\item{p}{\link[base]{numeric} \link[base]{vector} giving the probabilities where
the quantile function is evaluated.}
}
\value{
\itemize{
\item{\code{dweibullmix()}}{ gives a \link[base]{vector} of length \code{length(x)}
 containing the density at \code{x}.}
\item{\code{pweibullmix()}}{ gives a
\link[base]{vector} of length \code{length(q)} containing
the distribution function at the corresponding values of \code{q}.}
\item{\code{qweibullmix()}}{ gives a \link[base]{vector} of length \code{length(p)}
containing the quantiles at the corresponding values of \code{p}.}
\item{\code{rweibullmix()}}{ generates a \link[base]{vector} of length \code{n}
containing the random samples.}
}
}
\description{
The number of components in the mixed Weibull distribution is specified by the length
of the parameter vectors. The quantiles are numerically obtained from the distribution function using
monotone cubic splines.
}
\examples{

rweibullmix(10, shape = c(1, 3, 7), scale = c(2, 2, 4), prop = c(0.6, 0.3, 0.1))

dweibullmix(c(0, 2, 1), shape = c(1, 3), scale = c(2, 2), prop = c(0.6, 0.4))

prob <- pweibullmix(c(0.1, 7), shape = c(1, 3, 7), scale = c(2, 2, 4), prop = c(0.6, 0.3, 0.1))
prob
qweibullmix(prob, shape = c(1, 3, 7), scale = c(2, 2, 4), prop = c(0.6, 0.3, 0.1))

}
