% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_dm.R
\name{b_coding<-}
\alias{b_coding<-}
\alias{b_coding<-.drift_dm}
\alias{b_coding}
\alias{b_coding.drift_dm}
\alias{b_coding.fits_ids_dm}
\title{The Coding of the Boundaries}
\usage{
b_coding(object, ...) <- value

\method{b_coding}{drift_dm}(object, ...) <- value

b_coding(object, ...)

\method{b_coding}{drift_dm}(object, ...)

\method{b_coding}{fits_ids_dm}(object, ...)
}
\arguments{
\item{object}{an object of type \link{drift_dm} or \code{fits_ids_dm}
(see \link{load_fits_ids}).}

\item{...}{additional arguments.}

\item{value}{a named list, specifying how boundaries are coded (see Details).}
}
\value{
For \code{b_coding()} a list containing the boundary coding
For \verb{b_coding<-()} the updated \code{drift_dm} or \code{fits_ids_dm} object
}
\description{
Functions to get or set the "boundary coding" of an object.
}
\details{
\code{b_coding()} is a generic accessor function, and \verb{b_coding<-()} a
generic replacement function. The default methods get and set the "boundary
coding", which is an attribute of \link{drift_dm} model.

The boundary coding summarizes which response time belongs to which boundary
and how the boundaries shall be "labeled". The list specifies three entries:
\itemize{
\item \code{column}, contains a single character string, indicating which column
in an observed data set codes the boundaries.
\item \code{u_name_value}, contains a numeric or character vector of length 1. The
name of this vector gives a label for the upper boundary, and the entry
gives the value stored in \code{obs_data[[column]]} coding the upper boundary.
\item \code{l_name_value}, contains a numeric or character vector of length 1. The
name of this vector gives a label for the lower boundary, and the entry
gives the value stored in \code{obs_data[[column]]} coding the lower boundary.
}

The package \code{dRiftDM} has a default boundary coding:
\itemize{
\item \code{column} = "Error"
\item \code{u_name_value} = c("corr" = 0)
\item \code{l_name_value} = c("err" = 1)
}

Thus, per default, dRiftDM assumes that any observed data set has a column
"Error", providing the values 0 and 1 for the upper and lower boundary,
respectively. The upper and lower boundaries are labeled "corr" and "err",
respectively. These labels are used, for example, when calculating
statistics (see \link{calc_stats}).

When calling \verb{b_coding<-()} with \code{value = NULL}, the default "accuracy"
coding is evoked
}
\examples{
# show the default accuracy coding of dRiftDM
my_model <- ratcliff_dm() # get a pre-built model
b_coding(my_model)

# can be modified/replaced
b_coding(my_model)[["column"]] <- "Response"

# accessor method also available for fits_ids_dm objects
# get an exemplary fits_ids_dm object (see estimate_model_ids)
fits <- get_example_fits_ids()
names(b_coding(fits))

}
\seealso{
\code{\link[=drift_dm]{drift_dm()}}
}
