% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/defined.R
\name{strip_defined}
\alias{strip_defined}
\title{Strip the class from a defined vector}
\usage{
strip_defined(x)
}
\arguments{
\item{x}{A \code{defined} vector.}
}
\value{
A base R vector with attributes (\code{label}, \code{unit}, etc.) intact.
}
\description{
Converts a \code{defined} vector to a base R numeric or character,
retaining metadata as passive attributes.
}
\examples{
gdp <- defined(c(3897L, 7365L), label = "GDP", unit = "million dollars")
strip_defined(gdp)

fruits <- defined(c("apple", "avocado", "kiwi"),
  label = "Fruit", unit = "kg"
)

strip_defined(fruits)
}
\seealso{
\code{\link[=as_numeric]{as_numeric()}}, \code{\link[=as_character]{as_character()}}
}
