% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import.R
\name{import_flobs}
\alias{import_flobs}
\title{Import flobs.}
\usage{
import_flobs(
  column_name,
  table_name,
  conn,
  dir = ".",
  sep = "_-_",
  exists = FALSE,
  recursive = FALSE,
  replace = FALSE
)
}
\arguments{
\item{column_name}{A string of the name of the BLOB column.}

\item{table_name}{A string of the name of the existing table.}

\item{conn}{A SQLite connection object.}

\item{dir}{A string of the path to the directory to import files from.}

\item{sep}{A string of the separator between values in file names.}

\item{exists}{A logical scalar specifying whether the column must (TRUE) or
mustn't (FALSE) already exist or whether it doesn't matter (NA).
IF FALSE, a new BLOB column is created.}

\item{recursive}{A logical scalar indicating whether to recurse into file directory (TRUE) or not (FALSE).}

\item{replace}{A logical scalar indicating whether to replace existing flobs (TRUE) or not (FALSE).}
}
\value{
An invisible named vector indicating file name and whether the file was
successfully written to database.
}
\description{
Import \code{\link[flobr]{flob}}s to SQLite database column from directory.
Values in file name are matched to table primary key to determine where to write flob.
}
\examples{
conn <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")
DBI::dbGetQuery(conn, "CREATE TABLE Table1 (CharColumn TEXT PRIMARY KEY NOT NULL)")
DBI::dbWriteTable(conn, "Table1", data.frame(CharColumn = c("a", "b")), append = TRUE)
key <- data.frame(CharColumn = "a", stringsAsFactors = FALSE)[0,,drop = FALSE]
dir <- tempdir()
write.csv(key, file.path(dir, "a.csv"))
import_flobs("BlobColumn", "Table1", conn, dir)
DBI::dbDisconnect(conn)
}
