% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ParamTransfoCompRisks.R
\name{variance.cmprsk}
\alias{variance.cmprsk}
\title{Compute the variance of the estimates.}
\usage{
variance.cmprsk(
  parhatc,
  gammaest,
  data,
  admin,
  conf,
  inst,
  cf,
  eoi.indicator.names,
  Zbin,
  use.chol,
  n.trans,
  totparl
)
}
\arguments{
\item{parhatc}{Vector of estimated parameters, computed in the first part of
\code{estimate.cmprsk.R}.}

\item{gammaest}{Vector of estimated parameters in the regression model for
the control function.}

\item{data}{A data frame.}

\item{admin}{Boolean value indicating whether the data contains
administrative censoring.}

\item{conf}{Boolean value indicating whether the data contains confounding
and hence indicating the presence of \code{z} and, possibly, \code{w}.}

\item{inst}{Variable encoding which approach should be used for dealing with
the confounding. \code{inst = "cf"} indicates that the control function
approach should be used. \code{inst = "W"} indicates that the instrumental
variable should be used 'as is'. \code{inst = "None"} indicates that Z will
be treated as an exogenous covariate. Finally, when \code{inst = "oracle"},
this function will access the argument \code{realV} and use it as the values
for the control function. Default is \code{inst = "cf"}.}

\item{cf}{The control function used to estimate the second step.}

\item{eoi.indicator.names}{Vector of names of the censoring indicator columns
pertaining to events of interest. Events of interest will be modeled allowing
dependence between them, whereas all censoring events (corresponding to
indicator columns not listed in \code{eoi.indicator.names}) will be treated
as independent of every other event. If \code{eoi.indicator.names == NULL},
all events will be modeled dependently.}

\item{Zbin}{Indicator value indicating whether (\code{Zbin = TRUE}) or not
\code{Zbin = FALSE} the endogenous covariate is binary. Default is
\code{Zbin = NULL}, corresponding to the case when \code{conf == FALSE}.}

\item{use.chol}{Boolean value indicating whether the cholesky decomposition
was used in estimating the covariance matrix.}

\item{n.trans}{Number of competing risks in the model (and hence, number of
transformation models).}

\item{totparl}{Total number of covariate effects (including intercepts) in
all of the transformation models combined.}
}
\value{
Variance estimates of the provided vector of estimated parameters.
}
\description{
This function computes the variance of the estimates computed
by the 'estimate.cmprsk.R' function.
}
