% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/devRate_pheno.R
\name{devRateIBMPlot}
\alias{devRateIBMPlot}
\title{Plot phenology table}
\usage{
devRateIBMPlot(ibm, typeG = "density", threshold = 0.1)
}
\arguments{
\item{ibm}{The phenology model returned by devRateIBM function.}

\item{typeG}{The type of plot ("density" or "hist").}

\item{threshold}{The threshold rate of individuals for being represented
in a density plot (a numeric between 0 and 1).}
}
\value{
Nothing.
}
\description{
Plot phenology table
}
\examples{
data(exTropicalMoth)
forecastTsolanivora <- devRateIBM(
   tempTS = rnorm(n = 100, mean = 15, sd = 1),
   timeStepTS = 1,
   models = exTropicalMoth[[2]],
   numInd = 10,
   stocha = 0.015,
   timeLayEggs = 1)
devRateIBMPlot(ibm = forecastTsolanivora, typeG = "density", threshold = 0.1)
devRateIBMPlot(ibm = forecastTsolanivora, typeG = "hist")
}
