% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/difNLR.R
\name{logLik.difNLR}
\alias{logLik.difNLR}
\alias{AIC.difNLR}
\alias{BIC.difNLR}
\title{Log-likelihood and information criteria for an object of the \code{"difNLR"} class.}
\usage{
\method{logLik}{difNLR}(object, item = "all", ...)

\method{AIC}{difNLR}(object, item = "all", ...)

\method{BIC}{difNLR}(object, item = "all", ...)
}
\arguments{
\item{object}{an object of the \code{"difNLR"} class.}

\item{item}{numeric or character: either character \code{"all"} to apply for all
converged items (default), or a vector of item names (column names of the
\code{Data}), or item identifiers (integers specifying the column number).}

\item{...}{other generic parameters for S3 methods.}
}
\description{
S3 methods for extracting log-likelihood, Akaike's information criterion (AIC)
and Schwarz's Bayesian criterion (BIC) for an object of the \code{"difNLR"}
class.
}
\examples{
\dontrun{
# loading data
data(GMAT)
Data <- GMAT[, 1:20] # items
group <- GMAT[, "group"] # group membership variable

# testing both DIF effects using likelihood-ratio test and
# 3PL model with fixed guessing for groups
(x <- difNLR(Data, group, focal.name = 1, model = "3PLcg"))

# AIC, BIC, log-likelihood
AIC(x)
BIC(x)
logLik(x)

# AIC, BIC, log-likelihood for the first item
AIC(x, item = 1)
BIC(x, item = 1)
logLik(x, item = 1)
}
}
\references{
Drabinova, A. & Martinkova, P. (2017). Detection of differential item
functioning with nonlinear regression: A non-IRT approach accounting for
guessing. Journal of Educational Measurement, 54(4), 498--517,
\doi{10.1111/jedm.12158}.

Hladka, A. & Martinkova, P. (2020). difNLR: Generalized logistic regression
models for DIF and DDF detection. The R Journal, 12(1), 300--323,
\doi{10.32614/RJ-2020-014}.
}
\seealso{
\code{\link[difNLR]{difNLR}} for DIF detection among binary data using the generalized logistic regression model. \cr
\code{\link[stats]{logLik}} for a generic function extracting log-likelihood. \cr
\code{\link[stats]{AIC}} for a generic function calculating AIC and BIC.
}
\author{
Adela Hladka (nee Drabinova) \cr
Institute of Computer Science of the Czech Academy of Sciences \cr
\email{hladka@cs.cas.cz} \cr

Patricia Martinkova \cr
Institute of Computer Science of the Czech Academy of Sciences \cr
\email{martinkova@cs.cas.cz} \cr

Karel Zvara \cr
Faculty of Mathematics and Physics, Charles University \cr
}
