% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sharp.R
\name{normal_test_gen}
\alias{normal_test_gen}
\title{Sharp null sensitivity analysis for continuous exposures and binary outcomes
using normal approximation.}
\usage{
normal_test_gen(
  Z,
  Q,
  index,
  gamma,
  trans = identity,
  weights = NA,
  obsT = NULL,
  direct = "upper"
)
}
\arguments{
\item{Z}{A length N vector of (nonnegative) observed doses.}

\item{Q}{A length N vector of observed binary outcomes.}

\item{index}{A length N vector of indices indicating matched set membership.}

\item{gamma}{The nonnegative sensitivity parameter; gamma = 0 means no
unmeasured confounding.}

\item{trans}{The transformation of the doses to use for the test statistic.
Default is the identity function.}

\item{weights}{Weights to apply for the test statistic}

\item{obsT}{The observed value of the test statistic; default is NULL.}

\item{direct}{The direction of the test - "upper" or "lower"; default is upper.}
}
\value{
A list containing the following:

\item{obsT}{The observed value of the test statistic}
\item{exp}{The worst-case expectation}
\item{var}{The worst-case variance.}
\item{deviate}{The normal approximation deviate.}
}
\description{
Sharp null sensitivity analysis for continuous exposures and binary outcomes
using normal approximation.
}
\examples{
# Load the data
data <- treat_out_match
# Make a threshold at log(3.5) transformation function.
above = function(Z) { return(Z > log(3.5)) }
# Conduct randomization test using normal approximation.
solution <- normal_test_gen(data$treat, data$complain, data$match_ind,
gamma = 0, trans = above)
}
