% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anova_sites.R
\name{anova_sites}
\alias{anova_sites}
\title{Utility function: community-level permutation test in Double 
Constrained Correspondence Analysis (dc-CA)}
\usage{
anova_sites(object, permutations = 999, rpp = TRUE, n_axes = "all", by = NULL)
}
\arguments{
\item{object}{an object from \code{\link{dc_CA}}.}

\item{permutations}{a list of control values for the permutations as 
returned by the function \code{\link[permute]{how}}, or the number of 
permutations required (default 999), or a permutation matrix where each 
row gives the permuted indices.}

\item{rpp}{Logical indicating residual predictor permutation (default \code{TRUE}).
When \code{FALSE}, residual response permutation is used.}

\item{n_axes}{number of axes used in the test statistic (default: \code{"all"}). 
Example, the test statistic is the sum of the first two eigenvalues, 
if \code{n_axes=2}. With a numeric \code{n_axes} 
and model \code{~X + Condition(Z)}, the residuals of \code{X} 
with respect to \code{Z} are permuted with a test statistic equal to
the sum of the first \code{n_axes} eigenvalues of the fitted \code{Y}
in the model \code{Y ~ X + Z}, with \code{Y} the response in the model.
In the default \code{"all"}, the test statistic is all eigenvalues of the 
model \code{Y ~ X|Z}, \emph{i.e.} the effects of \code{X} after adjustment
for the effects on \code{Y} of \code{Z}.
If \code{by = "axis"}, the setting of \code{n_axes} is ignored.}

\item{by}{character \code{"axis"} which sets the test statistic to the 
first eigenvalue of the dc-CA model. Default: \code{NULL} which sets the 
test statistic to the inertia (sum of all double constrained eigenvalues; 
named  \code{constraintsTE} in the inertia element of \code{\link{dc_CA}}). 
This is the trait constrained inertia explained by the environmental 
predictors (without covariates), which is equal to the 
environmentally-constrained inertia explained by the traits (without trait 
covariates). The default is quicker computationally as it avoids
computation of an svd of permuted data sets.}
}
\value{
A list with two elements with names \code{table} and \code{eigenvalues}.
The \code{table} is as from \code{\link[vegan]{anova.cca}} and 
\code{eigenvalues} gives the dc-CA eigenvalues.
}
\description{
\code{anova_sites} performs the community-level permutation test of dc-CA 
when site weights vary.
The test uses residual predictor permutation (ter Braak 2022), which is 
robust against differences in site total abundance in the \code{response} 
in \code{\link{dc_CA}} (ter Braak & te Beest, 2022).
The arguments of the function are similar to those of 
\code{\link[vegan]{anova.cca}}, but more restricted. With equal site-totals 
as in \code{\link{dc_CA}}, \code{anova(object$RDAonEnv)} is much faster.
}
\details{
The algorithm is analogous to that of \code{\link{anova.wrda}}. The function
is used in \code{\link{anova.dcca}}.
}
\examples{
data("dune_trait_env")

# rownames are carried forward in results
rownames(dune_trait_env$comm) <- dune_trait_env$comm$Sites

mod <- dc_CA(formulaEnv = ~ A1 + Moist + Mag + Use + Manure,
             formulaTraits = ~ SLA + Height + LDMC + Seedmass + Lifespan,
             response = dune_trait_env$comm[, -1],  # must delete "Sites"
             dataEnv = dune_trait_env$envir,
             dataTraits = dune_trait_env$traits,
             verbose = FALSE)
anova(mod)

a_species <- anova_species(mod)
a_species
# anova_species can be used for manual forward selection of
# trait variables, as done for environmental variables in the demo 
# dune_FS_dcCA.r, based on the first eigenvalue and its significance
# and adding the first axis of the constrained species scores from mod to 
# the Condition of a new mod.
(eig1_and_pval <- c(eig = a_species$eig[1], pval = a_species$table$`Pr(>F)`[1]))
a_species$eig
anova_sites(mod)
}
\references{
ter Braak, C.J.F. & te Beest, D.E. 2022. Testing environmental effects
on taxonomic composition with canonical correspondence analysis:
alternative permutation tests are not equal.
Environmental and Ecological Statistics. 29 (4), 849-868.
\doi{10.1007/s10651-022-00545-4}

ter Braak, C.J.F. (2022) Predictor versus response permutation
for significance testing in weighted regression and redundancy analysis.
Journal of statistical computation and simulation, 92, 2041-2059.
\doi{10.1080/00949655.2021.2019256}
}
