% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/daz.R
\name{daz}
\alias{daz}
\alias{zad}
\title{Calculate Development-for-Age Z-score (DAZ)}
\usage{
daz(d, x, reference_table = NULL, dec = 3, verbose = FALSE)

zad(z, x, reference_table = NULL, dec = 2, verbose = FALSE)
}
\arguments{
\item{d}{Vector of D-scores}

\item{x}{Vector of ages (decimal age)}

\item{reference_table}{A \code{data.frame} with the LMS or BCT reference values.
The default \code{NULL} selects the default reference belonging to the \code{key},
as specified in the \code{base_population} field in \code{dscore::builtin_keys}.}

\item{dec}{The number of decimals (default \code{dec = 3}).}

\item{verbose}{Print out the used reference table (default \code{verbose = FALSE}).}

\item{z}{Vector of standard deviation scores (DAZ)}
}
\value{
Unnamed numeric vector with Z-scores of length \code{length(d)}.

Unnamed numeric vector with D-scores of length \code{length(z)}.
}
\description{
The \code{daz()} function calculated the Development-for-Age Z-score (DAZ).
The DAZ represents a child's D-score after adjusting for age by an
external age-conditional reference.
}
\details{
The \code{zad()} is the inverse of \code{daz()}: Given age and
the Z-score, it finds the raw D-score.

Note 1: The Box-Cox Cole and Green (BCCG) and Box-Cox t (BCT)
distributions model only positive D-score values. To increase
robustness, the \code{daz()} and \code{zad()} functions will round up any
D-scores lower than 1.0 to 1.0.

Note 2: The \code{daz()} and \code{zad()} function call modified version of the
\code{pBCT()} and \code{qBCT()} functions from \code{gamlss} for better handling
of \code{NA}'s and rounding.
}
\examples{
# using default reference and key
daz(d = c(35, 50), x = c(0.5, 1.0))

# print out names of the used reference table
daz(d = c(35, 50), x = c(0.5, 1.0), verbose = TRUE)

# using the default reference in key gcdg
reftab <- get_reference(key = "gcdg")
daz(d = c(35, 50), x = c(0.5, 1.0), reference_table = reftab)

# using Dutch reference in default key
reftab <- get_reference(population = "dutch", verbose = TRUE)
daz(d = c(35, 50), x = c(0.5, 1.0), reference_table = reftab)
# population median at ages 0.5, 1 and 2 years, default reference
zad(z = rep(0, 3), x = c(0.5, 1, 2))

# population median at ages 0.5, 1 and 2 years, gcdg key
reftab <- get_reference(key = "gcdg", verbose = TRUE)
zad(z = rep(0, 3), x = c(0.5, 1, 2), reference_table = reftab)

# population median at ages 0.5, 1 and 2 years, dutch key
reftab <- get_reference(key = "dutch", verbose = TRUE)
zad(z = rep(0, 3), x = c(0.5, 1, 2), reference = reftab)
}
\references{
Cole TJ, Green PJ (1992). Smoothing reference centile curves: The LMS
method and penalized likelihood. Statistics in Medicine, 11(10),
1305-1319.
}
\seealso{
\link[=get_reference]{dscore()}
}
\author{
Stef van Buuren
}
