% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc-stats.R
\name{calc_stats}
\alias{calc_stats}
\title{Calculate summary statistics for a variable}
\usage{
calc_stats(
  dt,
  target,
  target_name = target,
  treat,
  indent = nbsp(n = 4L),
  .total_dt = NULL,
  pct_dec = 1
)
}
\arguments{
\item{dt}{A \code{data.frame} containing, at least, the variables indicated in
\code{target} and \code{treat}.}

\item{target}{Target variable passed as a string for which summary
statistics are to be calculated.}

\item{target_name}{Heading for the target variable as a string. Defaults to
\code{target}.}

\item{treat}{A string indicating the grouping variable, e.g. the variable
specifying the treatment population.}

\item{indent}{A string to be used as indentation of summary statistics
labels. Defaults to four HTML non-breaking spaces (\verb{&nbsp;}).}

\item{.total_dt}{Separate table from \code{dt} from which to derive total counts
per group.}

\item{pct_dec}{Decimal places for reported figures.}
}
\value{
A \code{data.table} of summary statistics. The format depends on the
type of the \code{target} variable:
\itemize{
\item If the \code{target} variable is categorical, i.e. type \code{character}, \code{factor}
or \code{logical} then the output is that of \code{\link[=calc_counts]{calc_counts()}}.
\item If the \code{target} variable is numeric, then the output is that of
\code{\link[=calc_desc]{calc_desc()}}.
}
}
\description{
\code{\link[=calc_stats]{calc_stats()}} calculates summary statistics for a variable on groups. This
is a generic function; note that it dispatches based on the class of
\code{target} (second argument), not \code{dt} (first argument).
}
\examples{
# Calculate summary statistics of a numeric variable, e.g. `AGE`.
calc_stats(dt = adsl, "AGE", treat = "ARM")[[1]]

# Calculate summary statistics of a categorical variable, e.g. `SEX`.
calc_stats(dt = adsl, "SEX", treat = "ARM")[[1]]

}
