% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_tbl.R
\name{as_tbl}
\alias{as_tbl}
\title{Convert a duckplyr frame to a dbplyr table}
\usage{
as_tbl(.data)
}
\arguments{
\item{.data}{A lazy duckplyr frame or a data frame.}
}
\value{
A dbplyr table.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

This function converts a lazy duckplyr frame or a data frame
to a dbplyr table in duckplyr's internal connection.
This allows using dbplyr functions on the data,
including hand-written SQL queries.
Use \code{\link[=as_duckdb_tibble]{as_duckdb_tibble()}} to convert back to a lazy duckplyr frame.
}
\examples{
\dontshow{if (requireNamespace("dbplyr", quietly = TRUE)) withAutoprint(\{ # examplesIf}
df <- duckdb_tibble(a = 1L)
df

tbl <- as_tbl(df)
tbl

tbl \%>\%
  mutate(b = sql("a + 1")) \%>\%
  as_duckdb_tibble()
\dontshow{\}) # examplesIf}
}
