% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_beta.R
\name{sim_beta}
\alias{sim_beta}
\alias{simbeta}
\title{Calculate Beta Error and Statistical Power from Simulated Samples}
\usage{
sim_beta(data, alpha = 0.05)
}
\arguments{
\item{data}{An object of class \code{"ecocbo_data"} that results from applying
\code{\link[=prep_data]{prep_data()}} to a community dataset.}

\item{alpha}{Numeric. Significance level for Type I error. Defaults to 0.05.}
}
\value{
A list of class "ecocbo_beta", containing:
\itemize{
\item \verb{$Power}: a data frame with power and beta estimates across different
sampling efforts (\code{m} sites and \code{n} samples).
\item \verb{$Results}: a data frame with pseudo-F estimates for \code{simH0} and \code{simHa}.
\item \verb{$alpha}: significance level for Type I error.
}
}
\description{
Estimates the statistical power of a study by comparing variation under null
and alternative hypotheses. For instance, if the beta error is 0.25, there is
a 25\% chance of failing to detect a real difference, and the power of the study
is \eqn{1 - \beta}, meaning 0.75 in this case.
}
\details{
The function displays a summary matrix with estimated power values for various
sampling efforts.
}
\examples{
sim_beta(data = simResults, alpha = 0.05)

}
\references{
\itemize{
\item Underwood, A. J. (1997). Experiments in ecology: their logical
design and interpretation using analysis of variance. Cambridge university
press.
\item Underwood, A. J., & Chapman, M. G. (2003). Power, precaution,
Type II error and sampling design in assessment of environmental impacts.
Journal of Experimental Marine Biology and Ecology, 296(1), 49-70.
\item Anderson, M. J. (2014). Permutational multivariate analysis of
variance (PERMANOVA). Wiley statsref: statistics reference online, 1-15.
\item Guerra‐Castro, E. J., Cajas, J. C., Simões, N., Cruz‐Motta, J.
J., & Mascaró, M. (2021). SSP: an R package to estimate sampling effort in
studies of ecological communities. Ecography, 44(4), 561-573.
}
}
\seealso{
\code{\link[=plot_power]{plot_power()}}
\code{\link[=scompvar]{scompvar()}}
\code{\link[=sim_cbo]{sim_cbo()}}
\code{\link[=prep_data]{prep_data()}}
\code{\link[SSP:assempar]{SSP::assempar()}}
\code{\link[SSP:simdata]{SSP::simdata()}}
}
\author{
Edlin Guerra-Castro (\email{edlinguerra@gmail.com}), Arturo Sanchez-Porras
}
