% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/provider-snowflake-cortex.R
\name{chat_cortex_analyst}
\alias{chat_cortex_analyst}
\title{Create a chatbot that speaks to the Snowflake Cortex Analyst}
\usage{
chat_cortex_analyst(
  account = snowflake_account(),
  credentials = NULL,
  model_spec = NULL,
  model_file = NULL,
  api_args = list(),
  echo = c("none", "output", "all"),
  api_headers = character()
)
}
\arguments{
\item{account}{A Snowflake \href{https://docs.snowflake.com/en/user-guide/admin-account-identifier}{account identifier},
e.g. \code{"testorg-test_account"}. Defaults to the value of the
\code{SNOWFLAKE_ACCOUNT} environment variable.}

\item{credentials}{A list of authentication headers to pass into
\code{\link[httr2:req_headers]{httr2::req_headers()}}, a function that returns them when called, or
\code{NULL}, the default, to use ambient credentials.}

\item{model_spec}{A semantic model specification, or \code{NULL} when
using \code{model_file} instead.}

\item{model_file}{Path to a semantic model file stored in a Snowflake Stage,
or \code{NULL} when using \code{model_spec} instead.}

\item{api_args}{Named list of arbitrary extra arguments appended to the body
of every chat API call. Combined with the body object generated by ellmer
with \code{\link[=modifyList]{modifyList()}}.}

\item{echo}{One of the following options:
\itemize{
\item \code{none}: don't emit any output (default when running in a function).
\item \code{output}: echo text and tool-calling output as it streams in (default
when running at the console).
\item \code{all}: echo all input and output.
}

Note this only affects the \code{chat()} method.}

\item{api_headers}{Named character vector of arbitrary extra headers appended
to every chat API call.}
}
\value{
A \link{Chat} object.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

Please use \code{\link[=chat_snowflake]{chat_snowflake()}} instead as that appears to be where Snowflake
is putting their efforts.

Chat with the LLM-powered \href{https://docs.snowflake.com/en/user-guide/snowflake-cortex/cortex-analyst}{Snowflake Cortex Analyst}.
\subsection{Authentication}{

\code{chat_cortex_analyst()} picks up the following ambient Snowflake credentials:
\itemize{
\item A static OAuth token defined via the \code{SNOWFLAKE_TOKEN} environment
variable.
\item Key-pair authentication credentials defined via the \code{SNOWFLAKE_USER} and
\code{SNOWFLAKE_PRIVATE_KEY} (which can be a PEM-encoded private key or a path
to one) environment variables.
\item Posit Workbench-managed Snowflake credentials for the corresponding
\code{account}.
\item Viewer-based credentials on Posit Connect. Requires the \pkg{connectcreds}
package.
}
}

\subsection{Known limitations}{

Unlike most comparable model APIs, Cortex does not take a system prompt.
Instead, the caller must provide a "semantic model" describing available
tables, their meaning, and verified queries that can be run against them as a
starting point. The semantic model can be passed as a YAML string or via
reference to an existing file in a Snowflake Stage.

Note that Cortex does not support multi-turn, so it will not remember
previous messages. Nor does it support registering tools, and attempting to
do so will result in an error.

See \code{\link[=chat_snowflake]{chat_snowflake()}} to chat with more general-purpose models hosted on
Snowflake.
}
}
