% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.NestsResult.R
\name{plot.NestsResult}
\alias{plot.NestsResult}
\title{Plot the embryo growth}
\usage{
\method{plot}{NestsResult}(
  x,
  ...,
  parameters = NULL,
  fixed.parameters = NULL,
  resultmcmc = NULL,
  hessian = NULL,
  SE = NULL,
  temperatures = NULL,
  integral = NULL,
  derivate = NULL,
  hatchling.metric = NULL,
  stop.at.hatchling.metric = FALSE,
  M0 = NULL,
  weight = NULL,
  series = "all",
  TSP.borders = NULL,
  embryo.stages = NULL,
  STRN = NULL,
  TSP.begin = 0,
  TSP.end = 0.5,
  replicate.CI = 100,
  metric.end.incubation = "observed",
  col.stages = "blue",
  col.PT = "red",
  col.TSP = "gray",
  col.temperatures = "green",
  col.S = "black",
  lty.temperatures = 1,
  lwd.temperatures = 2,
  ylimT = NULL,
  ylimS = NULL,
  xlim = NULL,
  show.stages = TRUE,
  show.TSP = TRUE,
  show.third = TRUE,
  GTRN.CI = NULL,
  show.metric = TRUE,
  show.fioritures = TRUE,
  show.temperatures = TRUE,
  show.PT = TRUE,
  PT = c(mean = NA, SE = NA),
  show.hatchling.metric = TRUE,
  add = FALSE,
  lab.third = "2nd third of incubation",
  at.lab.third = 10,
  lab.PT = "PT",
  lab.stages = "Stages",
  at.lab.TSP = 8,
  lab.TSP = "TSP",
  mar = c(4, 5, 4, 5) + 0.3,
  xlab = "Days of incubation",
  ylabT = expression("Temperature in " * degree * "C"),
  ylabS = "Embryo metric",
  progress = TRUE,
  parallel = TRUE
)
}
\arguments{
\item{x}{A result file generated by searchR}

\item{...}{Parameters for plot()}

\item{parameters}{A set of parameters if result is not provided.}

\item{fixed.parameters}{Another set of parameters if result is not provided.}

\item{resultmcmc}{A mcmc result. Will be used rather than SE if provided.}

\item{hessian}{An Hessian matrix.}

\item{SE}{Standard error for each parameter if result is not provided, or replace the one in NestsResult. Use SE=NA to remove SE from NestResult}

\item{temperatures}{Timeseries of temperatures formatted using formatNests(). Will replace the one in result.}

\item{integral}{Function used to fit embryo growth: integral.Gompertz, integral.exponential or integral.linear}

\item{derivate}{Function used to fit embryo growth: dydt.Gompertz, dydt.exponential or dydt.linear. It will replace the one in NestsResult.}

\item{hatchling.metric}{Mean and SD of size of hatchlings}

\item{stop.at.hatchling.metric}{TRUE or FALSE. If TRUE, the model stops when proxy of size reached the mean hatchling.metric size.}

\item{M0}{Measure of hatchling size proxi at laying date}

\item{weight}{Weights of the different nests to estimate likelihood}

\item{series}{The name or number of the series to be displayed. Only one series can be displayed at a time.}

\item{TSP.borders}{The limits of TSP in stages. See embryo.stages parameter.}

\item{embryo.stages}{The embryo stages. At least TSP.borders stages must be provided to estimate TSP borders. See note.}

\item{STRN}{An object obtained from STRN()}

\item{TSP.begin}{Where TSP begin during the stage of beginning? In relative proportion of the stage.}

\item{TSP.end}{Where TSP begin during the stage of ending? In relative proportion of the stage.}

\item{replicate.CI}{Number of replicates to estimate CI. If 1, no CI is estimated.}

\item{metric.end.incubation}{The expected metric at the end of incubation. Used to calibrate TSP size. If NULL, take the maximum Mean of the hatchling.metric parameter. If NA, use the actual final size. Can be a vector and is recycled if necessary.}

\item{col.stages}{The color of the stages}

\item{col.PT}{The color of the pivotal temperature}

\item{col.TSP}{The color of the TSP}

\item{col.temperatures}{The color of the temperatures}

\item{col.S}{The color of the size or mass. Can be a vector (useful when series="all" option).}

\item{lty.temperatures}{Type of line for temperatures}

\item{lwd.temperatures}{Width of line for temperatures}

\item{ylimT}{Range of temperatures to be displayed}

\item{ylimS}{Range of size to be displayed}

\item{xlim}{Range of incubation days to be displayed}

\item{show.stages}{TRUE or FALSE, does the embryo stages should be displayed?}

\item{show.TSP}{TRUE or FALSE, does the TSP boders should be displayed?}

\item{show.third}{TRUE or FALSE, does the first and second third boders should be displayed?}

\item{GTRN.CI}{How to estimate CI; can be NULL, "SE", "MCMC", or "Hessian"}

\item{show.metric}{TRUE or FALSE, does the plot of embryo metric is shown?}

\item{show.fioritures}{If FALSE, set show.PT, show.temperatures, show.stages, show.TSP, show.third to FALSE, GTRN.CI to NULL}

\item{show.temperatures}{TRUE or FALSE, does the temperatures should be displayed?}

\item{show.PT}{TRUE or FALSE, does the pivotal temperature should be displayed?}

\item{PT}{Value for pivotal temperature, mean and SE}

\item{show.hatchling.metric}{TRUE or FALSE, does the hatchling size should be displayed}

\item{add}{If TRUE, all the curves are shown on the same graph}

\item{lab.third}{Label for 2nd third of incubation}

\item{at.lab.third}{Position of Label for 2nd third of incubation [default=10]; y-lim is scaled by at.lab.third}

\item{lab.PT}{Label for Pivotal Temperature}

\item{lab.stages}{Label for Stages}

\item{at.lab.TSP}{Position of Label for TSP [default=8]; y-lim is scaled by at.lab.third}

\item{lab.TSP}{Label for the TSP}

\item{mar}{Parameter mar used for plot}

\item{xlab}{Label for axis}

\item{ylabT}{Label for temperature axis}

\item{ylabS}{Label for size axis}

\item{progress}{If FALSE, the progress bar is not shown (useful for use with sweave or knitr)}

\item{parallel}{Should parallel computing be used ? TRUE or FALSE}

\item{NestsResult}{A NestsResult file generated by searchR}
}
\value{
Nothing
}
\description{
Plot the embryo growth from one or several nests.\cr
The embryo.stages is a named vector with relative size as compared to final size at the beginning of the stage. Names are the stages.\cr
For example for SCL in Caretta caretta:\cr
embryo.stages=structure(c(8.4, 9.4, 13.6, 13.8, 18.9, 23.5, 32.2, 35.2, 35.5, 38.5)/39.33), \cr
.Names = c("21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31"))\cr
 indicates that the stages 21 begins at the relative size of 8.4/39.33.\cr
Series can be indicated as the name of the series, its number or succesion of TRUE or FALSE. "all" indicates that all series must be printed.\cr
show.fioritures parameter does not affect show.hatchling.metric option.\cr
Note: Four species have predefined embryo stages. embryo.stages parameter can take the values:\cr
\itemize{
  \item \code{Caretta caretta.SCL}
  \item \code{Chelonia mydas.SCL}
  \item \code{Emys orbicularis.SCL}
  \item \code{Emys orbicularis.mass}
  \item \code{Podocnemis expansa.SCL}
  \item \code{Lepidochelys olivacea.SCL}
  \item \code{Generic.ProportionDevelopment}
  }
}
\details{
plot.NestsResult Plot the embryo growth
}
\examples{
\dontrun{
library(embryogrowth)
data(resultNest_4p_SSM)
plot(resultNest_4p_SSM, xlim=c(0,70), ylimT=c(22, 32), ylimS=c(0,45), series=1,  
	    SE=c(DHA=1.396525, DHH=4.101217, T12H=0.04330405, Rho25=1.00479), 
	    GTRN.CI = "SE", replicate.CI = 100, 
	    embryo.stages="Caretta caretta.SCL")
plot(resultNest_4p_SSM, xlim=c(0,70), ylimT=c(22, 32), ylimS=c(0,45), series=1, 
	    GTRN.CI = "Hessian", replicate.CI = 100, 
	    embryo.stages="Caretta caretta.SCL")
plot(resultNest_4p_SSM, xlim=c(0,70), ylimT=c(22, 32), ylimS=c(0,45), series=1,  
     resultmcmc = resultNest_mcmc_4p_SSM, 
	    GTRN.CI = "MCMC", replicate.CI = 100, 
     embryo.stages="Caretta caretta.SCL")
# to plot all the nest at the same time, use
plot(resultNest_4p_SSM, xlim=c(0,70), ylimT=c(22, 32), ylimS=c(0,45),  
	    series="all", show.fioritures=FALSE, add=TRUE, 
	    embryo.stages="Caretta caretta.SCL")
# to use color different for series
plot(resultNest_4p_SSM, xlim=c(0,70), ylimT=c(22, 32), ylimS=c(0,45), add=TRUE, 
	    series="all", show.fioritures=FALSE, col.S=c(rep("black", 5), rep("red", 6)), 
	    embryo.stages="Caretta caretta.SCL")
	    
# to plot all the temperature profiles

par(mar=c(4, 4, 1, 1))
plot(resultNest_4p_SSM$data[[1]][, 1]/60/24,
     resultNest_4p_SSM$data[[1]][, 2], bty="n", 
     las=1, xlab="Days of incubation", 
     ylab=expression("Temperatures in "*degree*"C"), 
     type="l", xlim=c(0,70),ylim=c(20, 35))
     
     for (i in 2:21) {
          par(new=TRUE)
          plot(resultNest_4p_SSM$data[[i]][, 1]/60/24,
          resultNest_4p_SSM$data[[i]][, 2], bty="n", 
          las=1, xlab="", ylab="", type="l", xlim=c(0,70),
          ylim=c(20, 35), axes = FALSE)
     }
}
}
\author{
Marc Girondot \email{marc.girondot@gmail.com}
}
