% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.tsd.R
\name{plot.tsd}
\alias{plot.tsd}
\title{Plot results of tsd() that best describe temperature-dependent sex determination}
\usage{
\method{plot}{tsd}(
  x,
  ...,
  show.observations = TRUE,
  show.model = TRUE,
  males.freq = TRUE,
  show.PTRT = TRUE,
  las.x = 1,
  las.y = 1,
  lab.PT = paste("Pivotal ", x$type),
  resultmcmc = NULL,
  chain = 1,
  l = 0.05,
  replicate.CI = 10000,
  range.CI = 0.95,
  mar = c(4, 4, 4, 1) + 0.4,
  temperatures.plot = seq(from = 25, to = 35, by = 0.1),
  durations.plot = seq(from = 40, to = 70, by = 0.1),
  lab.TRT = paste0("Transitional range of ", x$type, "s l=", x$l * 100, "\%"),
  col.TRT = "gray",
  col.TRT.CI = rgb(0.8, 0.8, 0.8, 0.8),
  col.PT.CI = rgb(0.8, 0.8, 0.8, 0.8),
  show.CI = TRUE,
  warn = TRUE,
  use.ggplot = TRUE
)
}
\arguments{
\item{x}{A result file generated by tsd()}

\item{...}{Parameters for plot()}

\item{show.observations}{Should the observations be shown}

\item{show.model}{Should the model be shown}

\item{males.freq}{Should the graph uses males relative frequency \link{TRUE} or females \link{FALSE}}

\item{show.PTRT}{Should the P and TRT information be shown}

\item{las.x}{las parameter for x axis}

\item{las.y}{las parameter for y axis}

\item{lab.PT}{Label to describe pivotal temperature}

\item{resultmcmc}{A result of tsd_MHmcmc()}

\item{chain}{What chain to be used is resultmcmc is provided}

\item{l}{Sex ratio limits to define TRT are l and 1-l}

\item{replicate.CI}{replicate.CI replicates from the hessian matrix to estimate CI}

\item{range.CI}{The range of confidence interval for estimation, default=0.95}

\item{mar}{The par("mar") parameter}

\item{temperatures.plot}{Temperatures used for showing curves of sex ratio}

\item{durations.plot}{Durations used for showing curves of sex ratio}

\item{lab.TRT}{Label to describe transitional range of temperature}

\item{col.TRT}{The color of TRT}

\item{col.TRT.CI}{The color of CI of TRT based on range.CI}

\item{col.PT.CI}{The color of CI of PT based on range.CI}

\item{show.CI}{Do the CI for the curve should be shown}

\item{warn}{Do the warnings must be shown ? TRUE or FALSE}

\item{use.ggplot}{Use ggplot graphics (experimental). TRUE or FALSE}
}
\value{
Nothing
}
\description{
Plot the estimates that best describe temperature-dependent sex determination.\cr
\insertRef{1515}{embryogrowth}\cr
\insertRef{3534}{embryogrowth}\cr
\insertRef{11754}{embryogrowth}\cr
\insertRef{5790}{embryogrowth}\cr
}
\details{
plot.tsd plot result of tsd() that best describe temperature-dependent sex determination
}
\examples{
\dontrun{
library(embryogrowth)
CC_AtlanticSW <- subset(DatabaseTSD, RMU.2010=="Atlantic, SW" & 
                          Species=="Caretta caretta" & (!is.na(Sexed) & Sexed!=0))
tsdL <- with (CC_AtlanticSW, tsd(males=Males, females=Females, 
                                 temperatures=Incubation.temperature.set, 
                                 equation="logistic"))
# By default, it will return a ggplot object
# Here I show the advantage of using a ggplot object
g <- plot(tsdL)
# You can remove named layers. For example:
names(g$layers)
g$layers["Observations"] <- NULL; plot(g)
# And add some
# Due to a bug in ggplot, it is necessary to remove all names to obtain correct legends
names(g$layers) <- NULL
g + geom_point(data=CC_AtlanticSW, aes(x=Incubation.temperature.set, y=Males/Sexed, 
               size = Sexed), inherit.aes = FALSE, show.legend = TRUE, shape=19)
# Force to use the original plot
plot(tsdL, use.ggplot = FALSE)
}
}
\seealso{
Other Functions for temperature-dependent sex determination: 
\code{\link{DatabaseTSD}},
\code{\link{DatabaseTSD.version}()},
\code{\link{P_TRT}()},
\code{\link{ROSIE}},
\code{\link{ROSIE.version}()},
\code{\link{TSP.list}},
\code{\link{predict.tsd}()},
\code{\link{stages}},
\code{\link{tsd}()},
\code{\link{tsd_MHmcmc}()},
\code{\link{tsd_MHmcmc_p}()}
}
\author{
Marc Girondot
}
\concept{Functions for temperature-dependent sex determination}
