% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic_functions.R
\name{boot_ML}
\alias{boot_ML}
\title{Bootstrap ML accuracy statistic estimation for multi-method data}
\usage{
boot_ML(
  type = c("binary", "ordinal", "continuous"),
  data,
  n_boot = 100,
  max_iter = 1000,
  tol = 1e-07,
  seed = NULL,
  ...
)
}
\arguments{
\item{type}{A string specifying the data type of the methods under evaluation.}

\item{data}{An \code{n_obs} by \code{n_method} \code{\link{matrix}} containing the
observed values for each method. If the dimensions are named, row names will
be used to name each observation (\code{obs_names}) and column names will be used
to name each measurement method (\code{method_names}).}

\item{n_boot}{number of bootstrap estimates to compute}

\item{max_iter}{The maximum number of EM algorithm iterations to compute before
reporting a result.}

\item{tol}{The minimum change in statistic estimates needed to continue
iterating the EM algorithm.}

\item{seed}{optional seed for RNG}

\item{...}{Additional arguments}
}
\value{
a list containing accuracy estimates, \code{v}, and the parameters used.
\item{v_0}{result from original data}
\item{v_star}{list containing results from each bootstrap resampling}
\item{params}{list containing the parameters used}
}
\description{
\code{boot_ML()} is a function used to generate bootstrap estimates of results generated
by \code{estimate_ML()} primarily for use in creating nonparametric confidence intervals.
}
\examples{
# Set seed for this example
set.seed(11001101)

# Generate data for 4 binary methods
my_sim <- generate_multimethod_data(
  "binary",
  n_obs = 75,
  n_method = 4,
  se = c(0.87, 0.92, 0.79, 0.95),
  sp = c(0.85, 0.93, 0.94, 0.80),
  method_names = c("alpha", "beta", "gamma", "delta"))

# Bootstrap ML results
boot_ex <- boot_ML(
  "binary",
  data = my_sim$generated_data,
  n_boot = 20)
}
