% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/endpoints.R
\name{pvt_dengue_sensors}
\alias{pvt_dengue_sensors}
\title{PAHO dengue digital surveillance sensors (North and South America)}
\usage{
pvt_dengue_sensors(
  auth,
  names,
  locations,
  epiweeks = "*",
  fetch_args = fetch_args_list()
)
}
\arguments{
\item{auth}{string. Restricted access key (not the same as API key).}

\item{names}{character. Names to fetch.}

\item{locations}{character. Locations to fetch.}

\item{epiweeks}{\code{\link{timeset}}. Epiweeks to fetch. Defaults to all ("*") dates.}

\item{fetch_args}{\code{\link{fetch_args}}. Additional arguments to pass to \code{fetch()}.}
}
\value{
\code{\link[tibble:tibble]{tibble::tibble}}
}
\description{
API docs: \url{https://cmu-delphi.github.io/delphi-epidata/api/dengue_sensors.html}
}
\examples{
\dontrun{
pvt_dengue_sensors(
  auth = Sys.getenv("SECRET_API_AUTH_SENSORS"),
  names = "ght",
  locations = "ag",
  epiweeks = epirange(201501, 202001)
)
}
}
\keyword{endpoint}
