% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sir.R
\name{seirmod2}
\alias{seirmod2}
\title{Gradient-function for the forced SEIR model}
\usage{
seirmod2(t, y, parameters)
}
\arguments{
\item{t}{Implicit argument for time}

\item{y}{A vector with initial values for the states}

\item{parameters}{A vector with parameter values for the SIR system}
}
\value{
A list of gradients
}
\description{
Gradient-function for the forced SEIR model
}
\examples{
require(deSolve)
times  = seq(0, 10, by=1/120)
paras  = c(mu = 1/50, N = 1, beta0 = 1000, beta1 = 0.2, sigma = 365/8, gamma = 365/5)
start = c(S=0.06, E=0, I=0.001, R = 0.939)
out=ode(start, times, seirmod2, paras)
}
